/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.validate.validator;

import com.meidusa.venus.validate.exception.ValidationException;
import com.meidusa.venus.validate.holder.ValueHolder;
import com.meidusa.venus.validate.validator.Validator;
import com.meidusa.venus.validate.validator.handler.ErrorMsgHandler;
import com.meidusa.venus.validate.validator.handler.ExceptionErrorMsgHandler;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ValidatorSupport
implements Validator {
    private static Pattern pattern = Pattern.compile("\\#\\{([^\\}]+)\\}");
    private static String STAND_FOR_NAME = "*";
    private static String STAND_FOR_VALUE = "&";
    private static Pattern validatorPattern = Pattern.compile("\\@\\{([^\\}]+)\\}");
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String message;
    private String type;
    private String[] messageParameters;
    private ValueHolder holder;
    private ErrorMsgHandler errHandler = new ExceptionErrorMsgHandler();

    public void setValueHolder(ValueHolder stack) {
        this.holder = stack;
    }

    public void setMessage(String message) {
        ArrayList<String> messageParams = new ArrayList<String>();
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            messageParams.add(matcher.group(1));
        }
        this.messageParameters = messageParams.toArray(new String[0]);
        this.message = matcher.replaceAll("%s");
    }

    public String getMessage(Object value) {
        if (this.message == null) {
            return "";
        }
        String result = null;
        if (this.messageParameters == null || this.messageParameters.length == 0) {
            result = this.message;
        } else {
            Object[] parsedParameters = new Object[this.messageParameters.length];
            int i = 0;
            while (i < this.messageParameters.length) {
                parsedParameters[i] = STAND_FOR_NAME.equals(this.messageParameters[i]) ? this.describeValidateName() : (STAND_FOR_VALUE.equals(this.messageParameters[i]) ? (value != null ? value.toString() : "null") : this.holder.findString(this.messageParameters[i]));
                ++i;
            }
            result = String.format(this.message, parsedParameters);
        }
        Matcher matcher = validatorPattern.matcher(result);
        StringBuffer sb = new StringBuffer();
        Object obj = null;
        while (matcher.find()) {
            try {
                obj = PropertyUtils.getProperty((Object)this, (String)matcher.group(1));
            }
            catch (Exception e) {
                obj = "null";
            }
            if (obj == null) {
                obj = "null";
            }
            matcher.appendReplacement(sb, obj.toString());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public abstract String describeValidateName();

    public String[] getMessageParameters() {
        return this.messageParameters;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    protected Object getFieldValue(String name) throws ValidationException {
        Object retVal = this.holder.findValue(name);
        return retVal;
    }

    protected void addValidationError(Object o) throws ValidationException {
        this.errHandler.handleValidationError(this.getMessage(o));
    }

    protected void addFieldValidationError(String propertyName, Object o) throws ValidationException {
        this.errHandler.handleValidationFieldError(propertyName, this.getMessage(o));
    }
}

