/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.validate.file;

import com.meidusa.venus.annotations.Service;
import com.meidusa.venus.validate.file.FilePathGenerator;
import com.meidusa.venus.validate.file.ValidationFileInfo;

public class DefaultFilePathGenerator
implements FilePathGenerator {
    private static char PACKAGE_DELIMITER = (char)46;
    private static char FOLDER_DELIMITER = (char)47;
    private String prefix;
    private String suffix;
    private String delimiter;

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public DefaultFilePathGenerator() {
        this.prefix = "";
        this.suffix = "validation.xml";
        this.delimiter = "-";
    }

    public DefaultFilePathGenerator(String prefix, String suffix, String delimiter) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.delimiter = delimiter;
    }

    public String toString() {
        return "DefaultValidationFilePathGenerator [prefix=" + this.prefix + ", suffix=" + this.suffix + ", delimiter=" + this.delimiter + "]";
    }

    @Override
    public String getConfigPath(ValidationFileInfo info) {
        String serviceName = null;
        Service serviceAnnotation = info.getService().getAnnotation(Service.class);
        if (serviceAnnotation != null) {
            serviceName = serviceAnnotation.name();
        }
        StringBuffer urlString = new StringBuffer();
        urlString.append(info.getService().getPackage().getName().replace(PACKAGE_DELIMITER, FOLDER_DELIMITER));
        urlString.append(FOLDER_DELIMITER);
        if (serviceName != null && serviceName.length() != 0) {
            urlString.append(serviceName);
        } else {
            urlString.append(Character.toLowerCase(info.getService().getSimpleName().charAt(0)));
            urlString.append(info.getService().getSimpleName().substring(1));
        }
        urlString.append(this.getDelimiter());
        urlString.append(info.getEndpoint());
        urlString.append(this.getDelimiter());
        if (info.getInnerParam() != null) {
            for (String innerParam : info.getInnerParam()) {
                urlString.append(innerParam);
                urlString.append(this.getDelimiter());
            }
        }
        if (info.getSuffix() != null && info.getSuffix().length() > 0) {
            urlString.append(info.getSuffix());
            urlString.append(this.getDelimiter());
        }
        urlString.append(this.getSuffix());
        return urlString.toString();
    }
}

