/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.validate.validator;

import com.meidusa.venus.validate.exception.ValidationException;
import com.meidusa.venus.validate.validator.FieldValidatorSupport;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexFieldValidator
extends FieldValidatorSupport {
    private String expression;
    private boolean caseSensitive = true;
    private boolean trim = true;
    private Pattern pattern;

    public void initPattern() {
        if (this.expression == null) {
            return;
        }
        this.pattern = this.isCaseSensitive() ? Pattern.compile(this.expression) : Pattern.compile(this.expression, 2);
    }

    @Override
    public void validate(Object object) throws ValidationException {
        Matcher matcher;
        if (this.expression != null && this.pattern == null) {
            this.initPattern();
        }
        String fieldName = this.getFieldName();
        if (object == null || this.expression == null) {
            return;
        }
        if (!(object instanceof String)) {
            return;
        }
        String str = ((String)object).trim();
        if (str.length() == 0) {
            return;
        }
        String compare = (String)object;
        if (this.trim) {
            compare = compare.trim();
        }
        if (!(matcher = this.pattern.matcher(compare)).matches()) {
            this.addFieldValidationError(fieldName, object);
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isTrimed() {
        return this.trim;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }
}

