/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.validate.chain.factory;

import com.meidusa.venus.annotations.Param;
import com.meidusa.venus.validate.chain.ValidatorChain;
import com.meidusa.venus.validate.chain.factory.ValidatorChainFactory;
import com.meidusa.venus.validate.exception.ValidationRuntimeException;
import com.meidusa.venus.validate.file.DefaultValidationFileParser;
import com.meidusa.venus.validate.file.ValidationFileInfo;
import com.meidusa.venus.validate.file.ValidationFileParser;
import com.meidusa.venus.validate.validator.ExpressionValidator;
import com.meidusa.venus.validate.validator.Validator;
import com.meidusa.venus.validate.validator.annotation.AnnotationValidatorFactory;
import com.meidusa.venus.validate.validator.annotation.Expression;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class VenusValidatorChainFactory
implements ValidatorChainFactory {
    private ValidationFileParser validationFileParser = new DefaultValidationFileParser();
    private String suffix = "";
    public static Map<Method, String[]> paramNameMapping = new HashMap<Method, String[]>();

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public ValidationFileParser getValidationFileParser() {
        return this.validationFileParser;
    }

    public void setValidationFileParser(ValidationFileParser validationFileParser) {
        this.validationFileParser = validationFileParser;
    }

    @Override
    public ValidatorChain createValidatorChain(Method method) {
        ValidationFileInfo info = new ValidationFileInfo(method.getDeclaringClass(), method.getName(), this.getSuffix());
        ValidatorChain chain = this.validationFileParser.parseValidationConfigs(info);
        this.calculateChainByAnnotation(chain, method);
        return chain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateChainByAnnotation(ValidatorChain chain, Method method) {
        String[] paramsNames = new String[method.getParameterTypes().length];
        Annotation[] methodAnnotation = method.getAnnotations();
        if (methodAnnotation != null) {
            for (int i = 0; i < methodAnnotation.length; ++i) {
                if (methodAnnotation[i].annotationType() != Expression.class) continue;
                ExpressionValidator validator = new ExpressionValidator();
                validator.setExpression(((Expression)methodAnnotation[i]).value());
                validator.setMessage(((Expression)methodAnnotation[i]).message());
                validator.setName(method.toString() + "'s param");
                chain.addValidator(validator);
            }
        }
        Annotation[][] fieldAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < fieldAnnotations.length; ++i) {
            int j;
            String fieldName = null;
            boolean fieldNameSet = false;
            for (j = 0; j < fieldAnnotations[i].length; ++j) {
                if (!(fieldAnnotations[i][j] instanceof Param)) continue;
                Param param = (Param)fieldAnnotations[i][j];
                fieldName = param.name();
                fieldNameSet = true;
            }
            if (!fieldNameSet) {
                fieldName = "param_" + String.valueOf(i);
            }
            paramsNames[i] = fieldName;
            for (j = 0; j < fieldAnnotations[i].length; ++j) {
                AnnotationValidatorFactory factory;
                Annotation fieldAnnotation = fieldAnnotations[i][j];
                com.meidusa.venus.validate.validator.annotation.Validator validatorAnnotation = fieldAnnotation.annotationType().getAnnotation(com.meidusa.venus.validate.validator.annotation.Validator.class);
                if (validatorAnnotation == null) continue;
                Class<? extends AnnotationValidatorFactory> factoryClass = validatorAnnotation.factory();
                try {
                    factory = factoryClass.newInstance();
                }
                catch (Exception e) {
                    throw new ValidationRuntimeException(e);
                }
                Object validator = factory.createValidator(fieldAnnotation, fieldName);
                if (validator == null) continue;
                chain.addValidator((Validator)validator);
            }
            Map<Method, String[]> map = paramNameMapping;
            synchronized (map) {
                paramNameMapping.put(method, paramsNames);
                continue;
            }
        }
    }
}

