/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.validate.chain;

import com.meidusa.venus.validate.chain.ValidatorChain;
import com.meidusa.venus.validate.exception.ValidationException;
import com.meidusa.venus.validate.holder.OgnlBasicValueHolder;
import com.meidusa.venus.validate.validator.FieldValidator;
import com.meidusa.venus.validate.validator.FieldValidatorSupport;
import com.meidusa.venus.validate.validator.Validator;
import com.meidusa.venus.validate.validator.ValidatorSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;

public class VenusValidatorChain
implements ValidatorChain {
    private List<Validator> expression = new ArrayList<Validator>();
    private Map<String, List<FieldValidator>> fieldValidators = new HashMap<String, List<FieldValidator>>();

    @Override
    public void validate(Object params) throws ValidationException {
        OgnlBasicValueHolder paramsHolder = new OgnlBasicValueHolder(params);
        for (Map.Entry<String, List<FieldValidator>> entry : this.fieldValidators.entrySet()) {
            try {
                Object o = PropertyUtils.getProperty((Object)params, (String)entry.getKey());
                for (FieldValidator validator : entry.getValue()) {
                    validator.validate(o);
                }
            }
            catch (Exception e) {
                if (e instanceof ValidationException) {
                    throw (ValidationException)e;
                }
                throw new ValidationException("can't get property " + entry.getKey(), e);
            }
        }
        for (Validator validator : this.expression) {
            if (validator instanceof FieldValidatorSupport) {
                FieldValidatorSupport fieldValidator = (FieldValidatorSupport)validator;
                fieldValidator.setValueHolder(paramsHolder);
                fieldValidator.validate(paramsHolder.findValue(fieldValidator.getFieldName()));
                continue;
            }
            if (!(validator instanceof ValidatorSupport)) continue;
            ValidatorSupport paramsValidator = (ValidatorSupport)validator;
            ((ValidatorSupport)validator).setValueHolder(paramsHolder);
            paramsValidator.validate(params);
        }
    }

    @Override
    public void addValidator(Validator validator) {
        if (validator instanceof FieldValidator) {
            List<FieldValidator> fieldValidatorList = this.fieldValidators.get(((FieldValidator)validator).getFieldName());
            if (fieldValidatorList == null) {
                fieldValidatorList = new LinkedList<FieldValidator>();
                this.fieldValidators.put(((FieldValidator)validator).getFieldName(), fieldValidatorList);
            }
            fieldValidatorList.add((FieldValidator)validator);
        } else {
            this.expression.add(validator);
        }
    }
}

