package com.meidusa.venus.validate.validator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.meidusa.venus.validate.chain.ValidatorChain;
import com.meidusa.venus.validate.chain.VenusValidatorChain;
import com.meidusa.venus.validate.exception.ValidationException;
import com.meidusa.venus.validate.exception.ValidationRuntimeException;
import com.meidusa.venus.validate.validator.annotation.AnnotationValidatorFactory;
import com.meidusa.venus.validate.validator.annotation.Expression;
import com.meidusa.venus.validate.validator.annotation.Validator;

public class VisitorFieldValidator extends FieldValidatorSupport {

	private String path;
	private Map<Class, ValidatorChain> internalValidatorChainMapping = new HashMap<Class, ValidatorChain>();
	private ValidatorChain internalValidatorChain = null;

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public ValidatorChain getInternalValidatorChain() {
		return internalValidatorChain;
	}

	public void setInternalValidatorChain(ValidatorChain internalValidatorChain) {
		this.internalValidatorChain = internalValidatorChain;
	}
	@Override
	public void validate(Object object) throws ValidationException {
		if(object == null) {
			return;
		}
		if(object instanceof Map) {
			Set<Map.Entry> entries = ((Map) object).entrySet();
			for(Entry element : entries) {
				validateObject(element.getValue());
			}
		} else if (object instanceof Collection) {
			for(Object element : (Collection)object) {
				validateObject(element);
			}
		} else if (object.getClass().isArray() ) {
			for(int i = 0 ; i < Array.getLength(object); i++) {
				validateObject(Array.get(object, i));
			}
		} else {
			validateObject(object);
		}
		
	}
	private void validateObject(Object object) throws ValidationException {
		ValidatorChain chain = internalValidatorChainMapping.get(object
				.getClass());
		if (chain == null) {
			synchronized (internalValidatorChainMapping) {
				chain = internalValidatorChainMapping.get(object.getClass());
				if (chain == null) {
					chain = initChain(object.getClass());
					this.internalValidatorChainMapping.put(object.getClass(),
							chain);
				}
			}
		}
		chain.validate(object);
		if (internalValidatorChain != null) {
			internalValidatorChain.validate(object);
		}
	}

	public ValidatorChain initChain(Class clazz) {
		ValidatorChain chain = new VenusValidatorChain();
		Annotation[] classAnnotation = clazz.getDeclaredAnnotations();
		if (classAnnotation != null) {
			for (int i = 0; i < classAnnotation.length; i++) {
				if (classAnnotation[i].getClass() == Expression.class) {
					ExpressionValidator exprValidator = new ExpressionValidator();
					exprValidator
							.setExpression(((Expression) classAnnotation[i])
									.value());
					exprValidator.setMessage(((Expression) classAnnotation[i])
							.message());
					exprValidator.setName(this.getFieldName());
					chain.addValidator(exprValidator);
				}
			}
		}
		this.analyzeFields(clazz, chain);
		return chain;

	}

	public void analyzeFields(Class<?> clazz, ValidatorChain chain) {
		do {
			for (Field field : clazz.getDeclaredFields()) {
				int modifiers = field.getModifiers();
				// fastbson will not process static and transient field
				if (Modifier.isStatic(modifiers)
						|| Modifier.isTransient(modifiers))
					continue;
				// for public field, fastbson will get/set field directly
				Annotation[] annotations = field.getAnnotations();
				for (int i = 0; i < annotations.length; i++) {
					Annotation fieldAnnotation = annotations[i];
					Validator validatorAnnotation = fieldAnnotation
							.annotationType().getAnnotation(Validator.class);
					if (validatorAnnotation != null) {
						Class<? extends AnnotationValidatorFactory> factoryClass = validatorAnnotation
								.factory();
						AnnotationValidatorFactory factory;
						try {
							factory = factoryClass.newInstance();
						} catch (Exception e) {
							throw new ValidationRuntimeException(e);
						}
						com.meidusa.venus.validate.validator.Validator validator = factory
								.createValidator(fieldAnnotation,
										field.getName(), field.getClass());
						if (validator != null) {
							chain.addValidator(validator);
						}
					} 

				}
			}
			// the while clause is to make sure to get the super class fiedl
			// as
			// well
		} while ((clazz = clazz.getSuperclass()) != Object.class);
	}



}
