/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.validate.validator;

import com.meidusa.venus.validate.chain.ValidatorChain;
import com.meidusa.venus.validate.chain.VenusValidatorChain;
import com.meidusa.venus.validate.exception.ValidationException;
import com.meidusa.venus.validate.exception.ValidationRuntimeException;
import com.meidusa.venus.validate.validator.ExpressionValidator;
import com.meidusa.venus.validate.validator.FieldValidatorSupport;
import com.meidusa.venus.validate.validator.Validator;
import com.meidusa.venus.validate.validator.annotation.AnnotationValidatorFactory;
import com.meidusa.venus.validate.validator.annotation.Expression;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class VisitorFieldValidator
extends FieldValidatorSupport {
    private String path;
    private Map<Class, ValidatorChain> internalValidatorChainMapping = new HashMap<Class, ValidatorChain>();
    private ValidatorChain internalValidatorChain = null;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ValidatorChain getInternalValidatorChain() {
        return this.internalValidatorChain;
    }

    public void setInternalValidatorChain(ValidatorChain internalValidatorChain) {
        this.internalValidatorChain = internalValidatorChain;
    }

    @Override
    public void validate(Object object) throws ValidationException {
        if (object instanceof Map) {
            Set entries = ((Map)object).entrySet();
            for (Map.Entry element : entries) {
                this.validateObject(element.getValue());
            }
        } else if (object instanceof Collection) {
            for (Object element : (Collection)object) {
                this.validateObject(element);
            }
        } else if (object.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(object); ++i) {
                this.validateObject(Array.get(object, i));
            }
        } else {
            this.validateObject(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateObject(Object object) throws ValidationException {
        ValidatorChain chain = this.internalValidatorChainMapping.get(object.getClass());
        if (chain == null) {
            Map<Class, ValidatorChain> map = this.internalValidatorChainMapping;
            synchronized (map) {
                chain = this.internalValidatorChainMapping.get(object.getClass());
                if (chain == null) {
                    chain = this.initChain(object.getClass());
                    this.internalValidatorChainMapping.put(object.getClass(), chain);
                }
            }
        }
        chain.validate(object);
        if (this.internalValidatorChain != null) {
            this.internalValidatorChain.validate(object);
        }
    }

    public ValidatorChain initChain(Class clazz) {
        VenusValidatorChain chain = new VenusValidatorChain();
        Annotation[] classAnnotation = clazz.getDeclaredAnnotations();
        if (classAnnotation != null) {
            for (int i = 0; i < classAnnotation.length; ++i) {
                if (classAnnotation[i].getClass() != Expression.class) continue;
                ExpressionValidator exprValidator = new ExpressionValidator();
                exprValidator.setExpression(((Expression)classAnnotation[i]).value());
                exprValidator.setMessage(((Expression)classAnnotation[i]).message());
                exprValidator.setName(this.getFieldName());
                chain.addValidator(exprValidator);
            }
        }
        this.analyzeFields(clazz, chain);
        return chain;
    }

    public void analyzeFields(Class<?> clazz, ValidatorChain chain) {
        do {
            for (Field field : clazz.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                Annotation[] annotations = field.getAnnotations();
                for (int i = 0; i < annotations.length; ++i) {
                    AnnotationValidatorFactory factory;
                    Annotation fieldAnnotation = annotations[i];
                    com.meidusa.venus.validate.validator.annotation.Validator validatorAnnotation = fieldAnnotation.annotationType().getAnnotation(com.meidusa.venus.validate.validator.annotation.Validator.class);
                    if (validatorAnnotation == null) continue;
                    Class<? extends AnnotationValidatorFactory> factoryClass = validatorAnnotation.factory();
                    try {
                        factory = factoryClass.newInstance();
                    }
                    catch (Exception e) {
                        throw new ValidationRuntimeException(e);
                    }
                    Object validator = factory.createValidator(fieldAnnotation, field.getName(), field.getClass());
                    if (validator == null) continue;
                    chain.addValidator((Validator)validator);
                }
            }
        } while ((clazz = clazz.getSuperclass()) != Object.class);
    }
}

