package com.meidusa.venus.validate;

import java.lang.reflect.Method;
import java.util.HashMap;

import com.meidusa.venus.validate.chain.ValidatorChain;
import com.meidusa.venus.validate.chain.factory.ValidatorChainFactory;
import com.meidusa.venus.validate.chain.factory.VenusValidatorChainFactory;

/**
 * ValidatorManager impelmentation. Load validatorChain while being used.
 * 
 * @author lichencheng.daisy
 * @since 1.0.0-SNAPSHOT
 * 
 */
public class VenusValidatorManager implements ValidatorManager {
	private ValidatorChainFactory chainFactory;

	private HashMap<Class<?>, HashMap<String, ValidatorChain>> validatorChainMapping;

	public ValidatorChainFactory getChainFactory() {
		return chainFactory;
	}

	public void setChainFactory(ValidatorChainFactory chainFactory) {
		this.chainFactory = chainFactory;
	}

	@Override
	public ValidatorChain getValidatorChain(Class<?> service,
			Method method) {

		String methodName = method.getName();
		HashMap<String, ValidatorChain> endpointChains = this.validatorChainMapping
				.get(service);
		if (endpointChains == null) {
			synchronized (validatorChainMapping) {
				endpointChains = validatorChainMapping.get(service);
				if (endpointChains == null) {
					endpointChains = new HashMap<String, ValidatorChain>();
					validatorChainMapping.put(service, endpointChains);
				}
			}
		}
		ValidatorChain returnChain = null;
		returnChain = endpointChains.get(methodName);
		if (returnChain == null) {
			synchronized (endpointChains) {
				returnChain = endpointChains.get(methodName);
				if (returnChain == null) {
					returnChain = chainFactory.createValidatorChain(service,
							method);
//					if (returnChain == null) {
//						returnChain = EmptyValidatorChain
//								.getEmptyValidatorChain();
//					}
					endpointChains.put(methodName, returnChain);
				}
			}
		}
		return returnChain;
	}

	@Override
	public void init() {
		this.validatorChainMapping = new HashMap<Class<?>, HashMap<String, ValidatorChain>>();
		this.chainFactory = new VenusValidatorChainFactory();

	}

}
