/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.validate.chain.factory;

import com.meidusa.venus.annotations.Param;
import com.meidusa.venus.validate.chain.ValidatorChain;
import com.meidusa.venus.validate.chain.factory.ValidatorChainFactory;
import com.meidusa.venus.validate.exception.ValidationRuntimeException;
import com.meidusa.venus.validate.file.DefaultValidationFileParser;
import com.meidusa.venus.validate.file.ValidationFileInfo;
import com.meidusa.venus.validate.file.ValidationFileParser;
import com.meidusa.venus.validate.validator.ExpressionValidator;
import com.meidusa.venus.validate.validator.Validator;
import com.meidusa.venus.validate.validator.annotation.AnnotationValidatorFactory;
import com.meidusa.venus.validate.validator.annotation.Expression;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class VenusValidatorChainFactory
implements ValidatorChainFactory {
    private ValidationFileParser validationFileParser = new DefaultValidationFileParser();
    private String suffix = "";

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public ValidationFileParser getValidationFileParser() {
        return this.validationFileParser;
    }

    public void setValidationFileParser(ValidationFileParser validationFileParser) {
        this.validationFileParser = validationFileParser;
    }

    @Override
    public ValidatorChain createValidatorChain(Class<?> service, Method method) {
        ValidationFileInfo info = new ValidationFileInfo(service, method.getName(), this.getSuffix());
        ValidatorChain chain = this.validationFileParser.parseValidationConfigs(info);
        this.calculateChainByAnnotation(chain, method);
        return chain;
    }

    private void calculateChainByAnnotation(ValidatorChain chain, Method method) {
        Annotation[] methodAnnotation = method.getAnnotations();
        if (methodAnnotation != null) {
            for (int i = 0; i < methodAnnotation.length; ++i) {
                if (methodAnnotation[i].annotationType() != Expression.class) continue;
                ExpressionValidator validator = new ExpressionValidator();
                validator.setExpression(((Expression)methodAnnotation[i]).value());
                validator.setMessage(((Expression)methodAnnotation[i]).message());
                validator.setName(method.toString() + "'s param");
                chain.addValidator(validator);
            }
        }
        Class<?>[] fieldClasses = method.getParameterTypes();
        Annotation[][] fieldAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < fieldAnnotations.length; ++i) {
            int j;
            Object fieldValidator = null;
            String fieldName = null;
            boolean fieldNameSet = false;
            for (j = 0; j < fieldAnnotations[i].length; ++j) {
                if (!(fieldAnnotations[i][j] instanceof Param)) continue;
                Param param = (Param)fieldAnnotations[i][j];
                fieldName = param.name();
                fieldNameSet = true;
            }
            if (!fieldNameSet) {
                throw new ValidationRuntimeException("param name not specified for method " + method.getName());
            }
            for (j = 0; j < fieldAnnotations[i].length; ++j) {
                AnnotationValidatorFactory factory;
                Annotation fieldAnnotation = fieldAnnotations[i][j];
                com.meidusa.venus.validate.validator.annotation.Validator validatorAnnotation = fieldAnnotation.annotationType().getAnnotation(com.meidusa.venus.validate.validator.annotation.Validator.class);
                if (validatorAnnotation == null) continue;
                Class<? extends AnnotationValidatorFactory> factoryClass = validatorAnnotation.factory();
                try {
                    factory = factoryClass.newInstance();
                }
                catch (Exception e) {
                    throw new ValidationRuntimeException(e);
                }
                Object validator = factory.createValidator(fieldAnnotation, fieldName, fieldClasses[i]);
                if (validator == null) continue;
                chain.addValidator((Validator)validator);
            }
        }
    }
}

