/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.validate.validator;

import com.meidusa.venus.validate.exception.ValidationException;
import com.meidusa.venus.validate.holder.ValueHolder;
import com.meidusa.venus.validate.validator.Validator;
import com.meidusa.venus.validate.validator.handler.ErrorMsgHandler;
import com.meidusa.venus.validate.validator.handler.ExceptionErrorMsgHandler;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public abstract class ValidatorSupport
implements Validator {
    private static Pattern pattern = Pattern.compile("\\%\\{([^\\}]+)\\}");
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected String message;
    private String type;
    private String[] messageParameters;
    private ValueHolder holder;
    private ErrorMsgHandler errHandler = new ExceptionErrorMsgHandler();

    public void setValueHolder(ValueHolder stack) {
        this.holder = stack;
    }

    public void setMessage(String message) {
        ArrayList<String> messageParams = new ArrayList<String>();
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            messageParams.add(matcher.group(1));
        }
        this.messageParameters = messageParams.toArray(new String[0]);
        this.message = matcher.replaceAll("%s");
    }

    public String getMessage() {
        if (this.messageParameters == null || this.messageParameters.length == 0) {
            return this.message;
        }
        Object[] parsedParameters = new Object[this.messageParameters.length];
        for (int i = 0; i < this.messageParameters.length; ++i) {
            parsedParameters[i] = this.holder.findString(this.messageParameters[i]);
        }
        return String.format(this.message, parsedParameters);
    }

    public String[] getMessageParameters() {
        return this.messageParameters;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    protected Object getFieldValue(String name) throws ValidationException {
        Object retVal = this.holder.findValue(name);
        return retVal;
    }

    protected void addValidationError() throws ValidationException {
        this.errHandler.handleValidationError(this.getMessage());
    }

    protected void addFieldValidationError(String propertyName) throws ValidationException {
        this.errHandler.handleValidationFieldError(propertyName, this.getMessage());
    }
}

