package com.meidusa.venus.validate.chain;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.meidusa.venus.validate.exception.ValidationException;
import com.meidusa.venus.validate.holder.OgnlBasicValueHolder;
import com.meidusa.venus.validate.holder.ValueHolder;
import com.meidusa.venus.validate.validator.FieldValidatorSupport;
import com.meidusa.venus.validate.validator.Validator;
import com.meidusa.venus.validate.validator.ValidatorSupport;

/**
 * ValidatorChain implemention
 * 
 * @author lichencheng.daisy
 * @since 1.0.0-SNAPSHOT
 * 
 */
public class VenusValidatorChain implements ValidatorChain {
	private List<Validator> validators;

	public VenusValidatorChain() {
		this.validators = new ArrayList<Validator>();
	}

	@Override
	public void validate(Object params) throws ValidationException {
		ValueHolder paramsHolder = new OgnlBasicValueHolder(params);
		for (Iterator<Validator> validatorIter = validators.iterator(); validatorIter
				.hasNext();) {
			Validator validator = validatorIter.next();
			if (validator instanceof FieldValidatorSupport) {
				FieldValidatorSupport fieldValidator = (FieldValidatorSupport) validator;
				fieldValidator.setValueHolder(paramsHolder);
				fieldValidator.validate(paramsHolder.findValue(fieldValidator
						.getFieldName()));
			} else if (validator instanceof ValidatorSupport) {
				ValidatorSupport paramsValidator = (ValidatorSupport) validator;
				((ValidatorSupport) validator).setValueHolder(paramsHolder);
				paramsValidator.validate(params);
			}
		}
	}

	@Override
	public void addValidator(Validator validator) {
		validators.add(validator);

	}

}
