/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.validate.validator;

import com.meidusa.venus.validate.exception.ValidationException;
import com.meidusa.venus.validate.validator.FieldValidatorSupport;
import org.apache.log4j.Priority;

public class DoubleRangeFieldValidator
extends FieldValidatorSupport {
    String maxInclusive = null;
    String minInclusive = null;
    String minExclusive = null;
    String maxExclusive = null;
    Double maxInclusiveValue = null;
    Double minInclusiveValue = null;
    Double minExclusiveValue = null;
    Double maxExclusiveValue = null;
    boolean fromAnnotation = false;

    @Override
    public void validate(Object object) throws ValidationException {
        Double value;
        String fieldName = this.getFieldName();
        try {
            value = Double.valueOf(object.toString());
        }
        catch (NumberFormatException e) {
            return;
        }
        if (!this.fromAnnotation) {
            this.parseParameterValues();
        }
        if (this.maxInclusiveValue != null && value.compareTo(this.maxInclusiveValue) > 0 || this.minInclusiveValue != null && value.compareTo(this.minInclusiveValue) < 0 || this.maxExclusiveValue != null && value.compareTo(this.maxExclusiveValue) >= 0 || this.minExclusiveValue != null && value.compareTo(this.minExclusiveValue) <= 0) {
            this.addFieldValidationError(fieldName);
        }
    }

    private void parseParameterValues() {
        this.minInclusiveValue = this.parseDouble(this.minInclusive);
        this.maxInclusiveValue = this.parseDouble(this.maxInclusive);
        this.minExclusiveValue = this.parseDouble(this.minExclusive);
        this.maxExclusiveValue = this.parseDouble(this.maxExclusive);
    }

    private Double parseDouble(String value) {
        block3: {
            if (value != null) {
                try {
                    return Double.valueOf(value);
                }
                catch (NumberFormatException e) {
                    if (!this.logger.isEnabledFor(Priority.WARN)) break block3;
                    this.logger.warn((Object)("DoubleRangeFieldValidator - [parseDouble]: Unable to parse given double parameter " + value));
                }
            }
        }
        return null;
    }

    public void setMaxInclusive(String maxInclusive) {
        this.maxInclusive = maxInclusive;
    }

    public String getMaxInclusive() {
        return this.maxInclusive;
    }

    public void setMinInclusive(String minInclusive) {
        this.minInclusive = minInclusive;
    }

    public String getMinInclusive() {
        return this.minInclusive;
    }

    public String getMinExclusive() {
        return this.minExclusive;
    }

    public void setMinExclusive(String minExclusive) {
        this.minExclusive = minExclusive;
    }

    public String getMaxExclusive() {
        return this.maxExclusive;
    }

    public void setMaxExclusive(String maxExclusive) {
        this.maxExclusive = maxExclusive;
    }

    public Double getMaxInclusiveValue() {
        return this.maxInclusiveValue;
    }

    public void setMaxInclusiveValue(Double maxInclusiveValue) {
        this.maxInclusiveValue = maxInclusiveValue;
    }

    public Double getMinInclusiveValue() {
        return this.minInclusiveValue;
    }

    public void setMinInclusiveValue(Double minInclusiveValue) {
        this.minInclusiveValue = minInclusiveValue;
    }

    public Double getMinExclusiveValue() {
        return this.minExclusiveValue;
    }

    public void setMinExclusiveValue(Double minExclusiveValue) {
        this.minExclusiveValue = minExclusiveValue;
    }

    public Double getMaxExclusiveValue() {
        return this.maxExclusiveValue;
    }

    public void setMaxExclusiveValue(Double maxExclusiveValue) {
        this.maxExclusiveValue = maxExclusiveValue;
    }

    public void setFromAnnotation(boolean fromAnnotation) {
        this.fromAnnotation = fromAnnotation;
    }
}

