/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.serializer.java;

import com.meidusa.venus.io.VenusObjectInputStream;
import com.meidusa.venus.io.VenusObjectOutputStream;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import com.meidusa.venus.io.serializer.Serializer;
import com.meidusa.venus.util.ThreadLocalMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Type;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSerializer
implements Serializer {
    private static Logger logger = LoggerFactory.getLogger(JavaSerializer.class);
    private static String _OBJECTINPUTSTREAM_ = "__ObjectInputStream__";
    private static String _OBJECTOUTPUTSTREAM_ = "__ObjectOutputStream__";

    private static VenusObjectInputStream getObjectInputStream() throws IOException {
        VenusObjectInputStream ois = (VenusObjectInputStream)ThreadLocalMap.get((Object)_OBJECTINPUTSTREAM_);
        if (ois == null) {
            ois = new VenusObjectInputStream();
            ThreadLocalMap.put((Object)_OBJECTINPUTSTREAM_, (Object)ois);
        }
        return ois;
    }

    private static VenusObjectOutputStream getObjectOutputStream() throws IOException {
        VenusObjectOutputStream os = (VenusObjectOutputStream)ThreadLocalMap.get((Object)_OBJECTOUTPUTSTREAM_);
        if (os == null) {
            os = new VenusObjectOutputStream();
            ThreadLocalMap.put((Object)_OBJECTOUTPUTSTREAM_, (Object)os);
        }
        return os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] toByts(Object obj) {
        byte[] bytes = null;
        ByteArrayOutputStream aos = new ByteArrayOutputStream();
        ObjectOutputStream oo = null;
        try {
            oo = new ObjectOutputStream(aos);
            oo.writeObject(obj);
            bytes = aos.toByteArray();
        }
        catch (IOException e) {
            logger.error("tobyts error", (Throwable)e);
        }
        finally {
            if (oo != null) {
                try {
                    oo.close();
                }
                catch (IOException e) {}
            }
        }
        return bytes;
    }

    public Object readObject(ServicePacketBuffer buffer) {
        if (!buffer.hasRemaining()) {
            return null;
        }
        int i = buffer.readInt();
        if (i <= 0 || i > buffer.remaining()) {
            return null;
        }
        byte[] toByts = new byte[i];
        buffer.readBytes(toByts, 0, i);
        try {
            return JavaSerializer.toObject(toByts);
        }
        catch (Exception e) {
            logger.error("toObject error", (Throwable)e);
            return null;
        }
    }

    public void writeObject(ServicePacketBuffer buffer, Object obj) {
        try {
            byte[] toByts = this.toByts(obj);
            buffer.writeInt(toByts.length);
            buffer.writeBytes(toByts);
        }
        catch (Exception e) {
            logger.error("writeObject error", (Throwable)e);
        }
    }

    @Override
    public Object decode(ServicePacketBuffer buffer, Type type) {
        return this.readObject(buffer);
    }

    @Override
    public void encode(ServicePacketBuffer buffer, Object obj) {
        this.writeObject(buffer, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object toObject(byte[] bytes) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bis);
        try {
            Object obj;
            Object object = obj = ois.readObject();
            return object;
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception e) {}
        }
    }

    @Override
    public Map<String, Object> decode(ServicePacketBuffer buffer, Map<String, Type> typeMap) {
        if (buffer.hasRemaining()) {
            return (Map)this.readObject(buffer);
        }
        return null;
    }

    @Override
    public byte[] encode(Object obj) {
        return this.toByts(obj);
    }

    @Override
    public Object decode(byte[] bts, Type type) {
        try {
            return JavaSerializer.toObject(bts);
        }
        catch (Exception e) {
            logger.error("toObject error", (Throwable)e);
            return null;
        }
    }

    @Override
    public Map<String, Object> decode(byte[] bts, Map<String, Type> typeMap) {
        try {
            return (Map)JavaSerializer.toObject(bts);
        }
        catch (Exception e) {
            logger.error("toObject error", (Throwable)e);
            return null;
        }
    }
}

