/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.packet.serialize;

import com.meidusa.venus.io.packet.AbstractServiceRequestPacket;
import com.meidusa.venus.io.packet.PacketConstant;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import com.meidusa.venus.io.serializer.Serializer;
import com.meidusa.venus.io.utils.GZipUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.Map;

public class SerializeServiceRequestPacket
extends AbstractServiceRequestPacket {
    private static final long serialVersionUID = 1L;
    private Map<String, Type> typeMap;
    private Serializer serializer;

    public SerializeServiceRequestPacket(Serializer serializer, Map<String, Type> typeMap) {
        this.typeMap = typeMap;
        this.serializer = serializer;
    }

    @Override
    protected void readBody(ServicePacketBuffer buffer) {
        super.readBody(buffer);
        if (buffer.hasRemaining()) {
            byte f = (byte)(this.flags & 0x10);
            if (f == 16) {
                byte[] bts = buffer.readLengthCodedBytes();
                if (bts != null & bts.length > 0) {
                    bts = GZipUtil.decompress(bts);
                    this.parameterMap = this.serializer.decode(bts, this.typeMap);
                }
            } else {
                this.parameterMap = this.serializer.decode(buffer, this.typeMap);
            }
        }
    }

    @Override
    protected void writeBody(ServicePacketBuffer buffer) throws UnsupportedEncodingException {
        super.writeBody(buffer);
        if (this.parameterMap != null) {
            byte[] bts = this.serializer.encode(this.parameterMap);
            if (bts != null) {
                if (PacketConstant.AUTO_COMPRESS_SIZE > 0 && bts.length > PacketConstant.AUTO_COMPRESS_SIZE) {
                    buffer.writeLengthCodedBytes(GZipUtil.compress(bts));
                    this.flags = (byte)(this.flags | 0x10);
                } else {
                    buffer.writeLengthCodedBytes(bts);
                }
            } else {
                buffer.writeInt(0);
            }
        }
    }
}

