/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.packet;

import com.meidusa.toolkit.net.packet.AbstractPacket;
import com.meidusa.venus.io.packet.PacketConstant;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import java.nio.ByteOrder;

public abstract class AbstractVenusPacket
extends AbstractPacket<ServicePacketBuffer>
implements PacketConstant {
    private static final long serialVersionUID = 1L;
    public static final int VENUS_HEADER_LENGTH = 10;
    protected int packetLength;
    public short protocolVersion = (short)2;
    public int type;

    protected void writeHead(ServicePacketBuffer buffer) {
        buffer.setPosition(0);
        buffer.writeInt(0);
        buffer.writeShort(this.protocolVersion);
        buffer.writeInt(this.type);
    }

    protected void initHead(ServicePacketBuffer buffer) {
        this.packetLength = buffer.readInt();
        this.protocolVersion = buffer.readShort();
        this.type = buffer.readInt();
    }

    protected void afterPacketWritten(ServicePacketBuffer buffer) {
        int position;
        this.packetLength = position = buffer.getPosition();
        buffer.setPosition(0);
        buffer.writeInt(this.packetLength);
        buffer.setPosition(position);
    }

    private static int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return (b3 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | (b0 & 0xFF) << 0;
    }

    static int getIntL(byte[] buf, int bi) {
        return AbstractVenusPacket.makeInt(buf[bi + 3], buf[bi + 2], buf[bi + 1], buf[bi + 0]);
    }

    static int getIntB(byte[] buf, int bi) {
        return AbstractVenusPacket.makeInt(buf[bi + 0], buf[bi + 1], buf[bi + 2], buf[bi + 3]);
    }

    private static long makeLong(byte b7, byte b6, byte b5, byte b4, byte b3, byte b2, byte b1, byte b0) {
        return (b7 & 0xFF) << 24 | (b6 & 0xFF) << 24 | (b5 & 0xFF) << 24 | (b4 & 0xFF) << 24 | (b3 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | (b0 & 0xFF) << 0;
    }

    static long getLongL(byte[] buf, int bi) {
        return AbstractVenusPacket.makeLong(buf[bi + 7], buf[bi + 6], buf[bi + 5], buf[bi + 4], buf[bi + 3], buf[bi + 2], buf[bi + 1], buf[bi + 0]);
    }

    static long getLongB(byte[] buf, int bi) {
        return AbstractVenusPacket.makeLong(buf[bi + 0], buf[bi + 1], buf[bi + 2], buf[bi + 3], buf[bi + 4], buf[bi + 5], buf[bi + 6], buf[bi + 7]);
    }

    public static int getType(byte[] buf) {
        return ServicePacketBuffer.BUFFER.getByteOrder() == ByteOrder.BIG_ENDIAN ? AbstractVenusPacket.getIntB(buf, 6) : AbstractVenusPacket.getIntL(buf, 6);
    }
}

