/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.util;

import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.parser.ParserConfig;
import com.meidusa.fastjson.parser.deserializer.FieldDeserializer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TypeUtils {
    public static final String castToString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static final Byte castToByte(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            return Byte.parseByte(strVal);
        }
        throw new JSONException("can not cast to byte, value : " + value);
    }

    public static final Character castToChar(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            if (strVal.length() != 1) {
                throw new JSONException("can not cast to byte, value : " + value);
            }
            return Character.valueOf(strVal.charAt(0));
        }
        throw new JSONException("can not cast to byte, value : " + value);
    }

    public static final Short castToShort(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            return Short.parseShort(strVal);
        }
        throw new JSONException("can not cast to short, value : " + value);
    }

    public static final BigDecimal castToBigDecimal(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        String strVal = value.toString();
        if (strVal.length() == 0) {
            return null;
        }
        return new BigDecimal(strVal);
    }

    public static final BigInteger castToBigInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        String strVal = value.toString();
        if (strVal.length() == 0) {
            return null;
        }
        return new BigInteger(strVal);
    }

    public static final Float castToFloat(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            String strVal = value.toString();
            if (strVal.length() == 0) {
                return null;
            }
            return Float.valueOf(Float.parseFloat(strVal));
        }
        throw new JSONException("can not cast to float, value : " + value);
    }

    public static final Double castToDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String strVal = value.toString();
            if (strVal.length() == 0) {
                return null;
            }
            return Double.parseDouble(strVal);
        }
        throw new JSONException("can not cast to double, value : " + value);
    }

    public static final java.util.Date castToDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        if (value instanceof java.util.Date) {
            return (java.util.Date)value;
        }
        long longValue = 0L;
        if (value instanceof Number) {
            longValue = ((Number)value).longValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            longValue = Long.parseLong(strVal);
        }
        if (longValue <= 0L) {
            throw new JSONException("can not cast to Date, value : " + value);
        }
        return new java.util.Date(longValue);
    }

    public static final Date castToSqlDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            return new Date(((Calendar)value).getTimeInMillis());
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof java.util.Date) {
            return new Date(((java.util.Date)value).getTime());
        }
        long longValue = 0L;
        if (value instanceof Number) {
            longValue = ((Number)value).longValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            longValue = Long.parseLong(strVal);
        }
        if (longValue <= 0L) {
            throw new JSONException("can not cast to Date, value : " + value);
        }
        return new Date(longValue);
    }

    public static final Timestamp castToTimestamp(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            return new Timestamp(((Calendar)value).getTimeInMillis());
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        long longValue = 0L;
        if (value instanceof Number) {
            longValue = ((Number)value).longValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            longValue = Long.parseLong(strVal);
        }
        if (longValue <= 0L) {
            throw new JSONException("can not cast to Date, value : " + value);
        }
        return new Timestamp(longValue);
    }

    public static final Long castToLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            return Long.parseLong(strVal);
        }
        throw new JSONException("can not cast to long, value : " + value);
    }

    public static final Integer castToInt(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            return Integer.parseInt(strVal);
        }
        throw new JSONException("can not cast to int, value : " + value);
    }

    public static final Boolean castToBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.length() == 0) {
                return null;
            }
            if ("true".equals(str)) {
                return Boolean.TRUE;
            }
            if ("false".equals(str)) {
                return Boolean.FALSE;
            }
            if ("1".equals(str)) {
                return Boolean.TRUE;
            }
        }
        throw new JSONException("can not cast to int, value : " + value);
    }

    public static final <T> T castToJavaBean(Object obj, Class<T> clazz) {
        return TypeUtils.cast(obj, clazz, ParserConfig.getGlobalInstance());
    }

    public static final <T> T cast(Object obj, Class<T> clazz, ParserConfig mapping) {
        String strVal;
        if (obj == null) {
            return null;
        }
        if (clazz == obj.getClass()) {
            return (T)obj;
        }
        if (obj instanceof Map) {
            if (clazz == Map.class) {
                return (T)obj;
            }
            return TypeUtils.castToJavaBean((Map)obj, clazz, mapping);
        }
        if (clazz.isArray() && obj instanceof Collection) {
            Collection collection = (Collection)obj;
            int index = 0;
            Object array = Array.newInstance(clazz.getComponentType(), collection.size());
            for (Object item : collection) {
                Object value = TypeUtils.cast(item, clazz.getComponentType(), mapping);
                Array.set(array, index, value);
                ++index;
            }
            return (T)array;
        }
        if (clazz.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return (T)TypeUtils.castToBoolean(obj);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return (T)TypeUtils.castToByte(obj);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return (T)TypeUtils.castToShort(obj);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return (T)TypeUtils.castToInt(obj);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return (T)TypeUtils.castToLong(obj);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return (T)TypeUtils.castToFloat(obj);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return (T)TypeUtils.castToDouble(obj);
        }
        if (clazz == String.class) {
            return (T)TypeUtils.castToString(obj);
        }
        if (clazz == BigDecimal.class) {
            return (T)TypeUtils.castToBigDecimal(obj);
        }
        if (clazz == BigInteger.class) {
            return (T)TypeUtils.castToBigInteger(obj);
        }
        if (clazz == java.util.Date.class) {
            return (T)TypeUtils.castToDate(obj);
        }
        if (clazz == Date.class) {
            return (T)TypeUtils.castToSqlDate(obj);
        }
        if (clazz == Timestamp.class) {
            return (T)TypeUtils.castToTimestamp(obj);
        }
        if (clazz.isEnum()) {
            return TypeUtils.castToEnum(obj, clazz, mapping);
        }
        if (obj instanceof String && (strVal = (String)obj).length() == 0) {
            return null;
        }
        throw new JSONException("can not cast to : " + clazz.getName());
    }

    public static final <T> T castToEnum(Object obj, Class<T> clazz, ParserConfig mapping) {
        try {
            if (obj instanceof String) {
                String name = (String)obj;
                if (name.length() == 0) {
                    return null;
                }
                return Enum.valueOf(clazz, name);
            }
            if (obj instanceof Number) {
                Object[] values;
                int ordinal = ((Number)obj).intValue();
                Method method = clazz.getMethod("values", new Class[0]);
                for (Object value : values = (Object[])method.invoke(null, new Object[0])) {
                    Enum e = (Enum)value;
                    if (e.ordinal() != ordinal) continue;
                    return (T)e;
                }
            }
        }
        catch (Exception ex) {
            throw new JSONException("can not cast to : " + clazz.getName(), ex);
        }
        throw new JSONException("can not cast to : " + clazz.getName());
    }

    public static final <T> T cast(Object obj, Type type, ParserConfig mapping) {
        String strVal;
        if (obj == null) {
            return null;
        }
        if (type instanceof Class) {
            return TypeUtils.cast(obj, (Class)type, mapping);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.cast(obj, (ParameterizedType)type, mapping);
        }
        if (obj instanceof String && (strVal = (String)obj).length() == 0) {
            return null;
        }
        throw new JSONException("can not cast to : " + type);
    }

    public static final <T> T cast(Object obj, ParameterizedType type, ParserConfig mapping) {
        String strVal;
        Type rawTye = type.getRawType();
        if (rawTye == List.class || rawTye == ArrayList.class) {
            Type itemType = type.getActualTypeArguments()[0];
            if (obj instanceof Iterable) {
                ArrayList<T> list = new ArrayList<T>();
                for (Object item : (Iterable)obj) {
                    list.add(TypeUtils.cast(item, itemType, mapping));
                }
                return (T)list;
            }
        }
        if (rawTye == Map.class || rawTye == HashMap.class) {
            Type keyType = type.getActualTypeArguments()[0];
            Type valueType = type.getActualTypeArguments()[1];
            if (obj instanceof Map) {
                HashMap<T, T> map = new HashMap<T, T>();
                for (Map.Entry entry : ((Map)obj).entrySet()) {
                    T key = TypeUtils.cast(entry.getKey(), keyType, mapping);
                    T value = TypeUtils.cast(entry.getValue(), valueType, mapping);
                    map.put(key, value);
                }
                return (T)map;
            }
        }
        if (obj instanceof String && (strVal = (String)obj).length() == 0) {
            return null;
        }
        throw new JSONException("can not cast to : " + type);
    }

    public static final <T> T castToJavaBean(Map<String, Object> map, Class<T> clazz, ParserConfig mapping) {
        try {
            if (clazz == StackTraceElement.class) {
                String declaringClass = (String)map.get("className");
                String methodName = (String)map.get("methodName");
                String fileName = (String)map.get("fileName");
                Number value = (Number)map.get("lineNumber");
                int lineNumber = value == null ? 0 : value.intValue();
                return (T)new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
            }
            Object iClassObject = map.get("class");
            if (iClassObject instanceof String) {
                String className = (String)iClassObject;
                try {
                    Class<?> iClass = Thread.currentThread().getContextClassLoader().loadClass(className);
                    clazz = iClass;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            Map<String, FieldDeserializer> setters = mapping.getFieldDeserializers(clazz);
            T object = clazz.newInstance();
            for (Map.Entry<String, FieldDeserializer> entry : setters.entrySet()) {
                String key = entry.getKey();
                Method method = entry.getValue().getMethod();
                Object value = map.get(key);
                value = TypeUtils.cast(value, method.getGenericParameterTypes()[0], mapping);
                method.invoke(object, value);
            }
            return object;
        }
        catch (Exception e) {
            throw new JSONException(e.getMessage(), e);
        }
    }
}

