/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.packet;

import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import java.io.UnsupportedEncodingException;

public abstract class AuthenPacket
extends AbstractServicePacket {
    private static final long serialVersionUID = 1L;
    public byte authType;
    public int capabilities = 16;
    public byte shakeSerializeType;
    public String client = "VENUS-JAVA-CLIENT";
    public String version = "2.0.5-BETA";
    public String username;

    public AuthenPacket() {
        this.type = 0x3100000;
    }

    @Override
    protected void writeBody(ServicePacketBuffer buffer) throws UnsupportedEncodingException {
        super.writeBody(buffer);
        buffer.writeByte(this.authType);
        buffer.writeInt(this.capabilities);
        buffer.writeByte(this.shakeSerializeType);
        buffer.writeLengthCodedString(this.client, "UTF8");
        buffer.writeLengthCodedString(this.version, "UTF8");
        buffer.writeLengthCodedString(this.username, "UTF8");
    }

    @Override
    protected void readBody(ServicePacketBuffer buffer) {
        super.readBody(buffer);
        this.authType = buffer.readByte();
        this.capabilities = buffer.readInt();
        this.shakeSerializeType = buffer.readByte();
        this.client = buffer.readLengthCodedString("UTF8");
        this.version = buffer.readLengthCodedString("UTF8");
        this.username = buffer.readLengthCodedString("UTF8");
    }

    public static byte getAuthenType(byte[] message) {
        return message[24];
    }
}

