/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.parser;

import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.parser.DefaultJSONParser;
import com.meidusa.fastjson.parser.Feature;
import com.meidusa.fastjson.parser.JSONScanner;
import com.meidusa.fastjson.parser.JSONToken;
import com.meidusa.fastjson.parser.ParserConfig;
import com.meidusa.fastjson.parser.deserializer.DefaultObjectDeserializer;
import com.meidusa.fastjson.parser.deserializer.IntegerDeserializer;
import com.meidusa.fastjson.parser.deserializer.ObjectDeserializer;
import com.meidusa.fastjson.parser.deserializer.StringDeserializer;
import com.meidusa.fastjson.util.TypeUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultExtJSONParser
extends DefaultJSONParser {
    private DefaultObjectDeserializer derializer = new DefaultObjectDeserializer();
    private static final Set<Class<?>> primitiveClasses = new HashSet();

    static {
        primitiveClasses.add(Boolean.TYPE);
        primitiveClasses.add(Byte.TYPE);
        primitiveClasses.add(Short.TYPE);
        primitiveClasses.add(Integer.TYPE);
        primitiveClasses.add(Long.TYPE);
        primitiveClasses.add(Float.TYPE);
        primitiveClasses.add(Double.TYPE);
        primitiveClasses.add(Boolean.class);
        primitiveClasses.add(Byte.class);
        primitiveClasses.add(Short.class);
        primitiveClasses.add(Integer.class);
        primitiveClasses.add(Long.class);
        primitiveClasses.add(Float.class);
        primitiveClasses.add(Double.class);
        primitiveClasses.add(BigInteger.class);
        primitiveClasses.add(BigDecimal.class);
        primitiveClasses.add(String.class);
    }

    public DefaultExtJSONParser(String input) {
        this(input, ParserConfig.getGlobalInstance());
    }

    public DefaultExtJSONParser(String input, ParserConfig mapping) {
        super(input, mapping);
    }

    public DefaultExtJSONParser(String input, ParserConfig mapping, int features) {
        super(input, mapping, features);
    }

    public DefaultExtJSONParser(char[] input, int length, ParserConfig mapping, int features) {
        super(input, length, mapping, features);
    }

    public ParserConfig getConfig() {
        return this.config;
    }

    public void setConfig(ParserConfig config) {
        this.config = config;
    }

    public <T> T parseObject(Class<T> clazz) {
        return this.parseObject((Type)clazz);
    }

    public Map<String, Object> parseObjectWithTypeMap(Map<String, Type> typeMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        JSONScanner lexer = (JSONScanner)this.lexer;
        if (lexer.token() != 12) {
            throw new JSONException("syntax error, expect {, actual " + lexer.token());
        }
        while (true) {
            String key;
            lexer.skipWhitespace();
            char ch = lexer.getCurrent();
            if (this.isEnabled(Feature.AllowArbitraryCommas)) {
                while (ch == ',') {
                    lexer.incrementBufferPosition();
                    lexer.skipWhitespace();
                    ch = lexer.getCurrent();
                }
            }
            if (ch == '\"') {
                key = lexer.scanSymbol(this.symbolTable, '\"');
                lexer.skipWhitespace();
                ch = lexer.getCurrent();
                if (ch != ':') {
                    throw new JSONException("expect ':' at " + lexer.pos() + ", name " + key);
                }
            } else {
                if (ch == '}') {
                    lexer.incrementBufferPosition();
                    lexer.resetStringPosition();
                    lexer.nextToken();
                    return map;
                }
                if (ch == '\'') {
                    if (!this.isEnabled(Feature.AllowSingleQuotes)) {
                        throw new JSONException("syntax error");
                    }
                    key = lexer.scanSymbol(this.symbolTable, '\'');
                    lexer.skipWhitespace();
                    ch = lexer.getCurrent();
                    if (ch != ':') {
                        throw new JSONException("expect ':' at " + lexer.pos());
                    }
                } else {
                    if ((byte)ch == 26) {
                        lexer.nextToken();
                        if (lexer.isEOF()) {
                            return map;
                        }
                        return map;
                    }
                    if (ch == ',') {
                        throw new JSONException("syntax error");
                    }
                    if (!this.isEnabled(Feature.AllowUnQuotedFieldNames)) {
                        throw new JSONException("syntax error");
                    }
                    key = lexer.scanSymbolUnQuoted(this.symbolTable);
                    lexer.skipWhitespace();
                    ch = lexer.getCurrent();
                    if (ch != ':') {
                        throw new JSONException("expect ':' at " + lexer.pos() + ", actual " + ch);
                    }
                }
            }
            lexer.resetStringPosition();
            lexer.nextToken();
            lexer.nextToken();
            map.put(key, this.parseObject(typeMap.get(key)));
            lexer.skipWhitespace();
        }
    }

    @Override
    public <T> T parseObject(Type type) {
        if (this.lexer.token() == 8) {
            this.lexer.nextToken();
            return null;
        }
        ObjectDeserializer derializer = this.config.getDeserializer(type);
        try {
            return derializer.deserialze(this, type);
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    public <T> List<T> parseArray(Class<T> clazz) {
        ArrayList array = new ArrayList();
        this.parseArray(clazz, array);
        return array;
    }

    public void parseArray(Class<?> clazz, Collection array) {
        this.parseArray((Type)clazz, array);
    }

    public void parseArray(Type type, Collection array) {
        int token = this.lexer.token();
        if (token != 14) {
            throw new JSONException("exepct '[', but " + JSONToken.name(this.lexer.token()));
        }
        ObjectDeserializer deserializer = null;
        if (Integer.TYPE == type) {
            deserializer = IntegerDeserializer.instance;
            this.lexer.nextToken(2);
        } else if (String.class == type) {
            deserializer = StringDeserializer.instance;
            this.lexer.nextToken(4);
        } else {
            deserializer = this.config.getDeserializer(type);
            this.lexer.nextToken(deserializer.getFastMatchToken());
        }
        while (true) {
            Object val;
            if (this.isEnabled(Feature.AllowArbitraryCommas)) {
                while (this.lexer.token() == 16) {
                    this.lexer.nextToken();
                }
            }
            if (this.lexer.token() == 15) break;
            if (Integer.TYPE == type) {
                val = IntegerDeserializer.deserialze(this);
                array.add(val);
            } else if (String.class == type) {
                String value;
                if (this.lexer.token() == 4) {
                    value = this.lexer.stringVal();
                    this.lexer.nextToken(16);
                } else {
                    Object obj = this.parse();
                    value = obj == null ? null : obj.toString();
                }
                array.add(value);
            } else {
                val = deserializer.deserialze(this, type);
                array.add(val);
            }
            if (this.lexer.token() != 16) continue;
            this.lexer.nextToken(deserializer.getFastMatchToken());
        }
        this.lexer.nextToken(16);
    }

    public Object[] parseArray(Type[] types) {
        if (this.lexer.token() != 14) {
            throw new JSONException("syntax error");
        }
        Object[] list = new Object[types.length];
        if (types.length == 0) {
            this.lexer.nextToken(15);
            if (this.lexer.token() != 15) {
                throw new JSONException("syntax error");
            }
            this.lexer.nextToken(16);
            return new Object[0];
        }
        this.lexer.nextToken(2);
        int i = 0;
        while (i < types.length) {
            Object value;
            if (this.lexer.token() == 8) {
                value = null;
                this.lexer.nextToken(16);
            } else {
                Type type = types[i];
                if (type == Integer.TYPE || type == Integer.class) {
                    if (this.lexer.token() == 2) {
                        value = this.lexer.intValue();
                        this.lexer.nextToken(16);
                    } else {
                        value = this.parse();
                        value = TypeUtils.cast(value, type, this.config);
                    }
                } else if (type == String.class) {
                    if (this.lexer.token() == 4) {
                        value = this.lexer.stringVal();
                        this.lexer.nextToken(16);
                    } else {
                        value = this.parse();
                        value = TypeUtils.cast(value, type, this.config);
                    }
                } else {
                    boolean isArray = false;
                    Class<?> componentType = null;
                    if (i == types.length - 1 && type instanceof Class) {
                        Class clazz = (Class)type;
                        isArray = clazz.isArray();
                        componentType = clazz.getComponentType();
                    }
                    if (isArray && this.lexer.token() != 14) {
                        ArrayList varList = new ArrayList();
                        ObjectDeserializer derializer = this.config.getDeserializer(componentType);
                        int fastMatch = derializer.getFastMatchToken();
                        if (this.lexer.token() != 15) {
                            while (true) {
                                Object item = derializer.deserialze(this, type);
                                varList.add(item);
                                if (this.lexer.token() != 16) break;
                                this.lexer.nextToken(fastMatch);
                            }
                            if (this.lexer.token() != 15) {
                                throw new JSONException("syntax error :" + JSONToken.name(this.lexer.token()));
                            }
                        }
                        value = TypeUtils.cast(varList, type, this.config);
                    } else {
                        ObjectDeserializer derializer = this.config.getDeserializer(type);
                        value = derializer.deserialze(this, type);
                    }
                }
            }
            list[i] = value;
            if (this.lexer.token() == 15) break;
            if (this.lexer.token() != 16) {
                throw new JSONException("syntax error :" + JSONToken.name(this.lexer.token()));
            }
            if (i == types.length - 1) {
                this.lexer.nextToken(15);
            } else {
                this.lexer.nextToken(2);
            }
            ++i;
        }
        if (this.lexer.token() != 15) {
            throw new JSONException("syntax error");
        }
        this.lexer.nextToken(16);
        return list;
    }

    public void parseObject(Object object) {
        this.derializer.parseObject(this, object);
    }

    public Object parseArrayWithType(Type collectionType) {
        if (this.lexer.token() == 8) {
            this.lexer.nextToken();
            return null;
        }
        Type[] actualTypes = ((ParameterizedType)collectionType).getActualTypeArguments();
        if (actualTypes.length != 1) {
            throw new JSONException("not support type " + collectionType);
        }
        Type actualTypeArgument = actualTypes[0];
        if (actualTypeArgument instanceof Class) {
            ArrayList array = new ArrayList();
            this.parseArray((Class)actualTypeArgument, array);
            return array;
        }
        if (actualTypeArgument instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)actualTypeArgument;
            Type upperBoundType = wildcardType.getUpperBounds()[0];
            if (Object.class.equals((Object)upperBoundType)) {
                if (wildcardType.getLowerBounds().length == 0) {
                    return this.parse();
                }
                throw new JSONException("not support type : " + collectionType);
            }
            ArrayList array = new ArrayList();
            this.parseArray((Class)upperBoundType, array);
            return array;
        }
        if (actualTypeArgument instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)actualTypeArgument;
            Type[] bounds = typeVariable.getBounds();
            if (bounds.length != 1) {
                throw new JSONException("not support : " + typeVariable);
            }
            Type boundType = bounds[0];
            if (boundType instanceof Class) {
                ArrayList array = new ArrayList();
                this.parseArray((Class)boundType, array);
                return array;
            }
        }
        if (actualTypeArgument instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)actualTypeArgument;
            ArrayList array = new ArrayList();
            this.parseArray(parameterizedType, array);
            return array;
        }
        throw new JSONException("TODO : " + collectionType);
    }
}

