/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.util.concurrent;

import com.meidusa.toolkit.common.util.Tuple;
import com.meidusa.venus.util.concurrent.MultipleQueue;
import com.meidusa.venus.util.concurrent.Named;
import com.meidusa.venus.util.concurrent.QueueConfig;
import java.util.Queue;

public abstract class MultiQueueRunnable
implements Runnable,
Named {
    private Tuple<QueueConfig, Queue> tuple;
    private MultipleQueue wrapper;

    @Override
    public final void run() {
        long start = System.currentTimeMillis();
        try {
            this.doRun();
        }
        finally {
            this.finished(start, System.currentTimeMillis());
        }
    }

    public abstract void doRun();

    final void setQueue(MultipleQueue wrapper, Tuple<QueueConfig, Queue> tuple) {
        this.tuple = tuple;
        this.wrapper = wrapper;
    }

    final void taked() {
        ((QueueConfig)this.tuple.left).incrementAndGet();
    }

    final void finished(long start, long current) {
        if (this.wrapper != null) {
            MultipleQueue temp = this.wrapper;
            Tuple<QueueConfig, Queue> tupleTemp = this.tuple;
            this.tuple = null;
            this.wrapper = null;
            temp.finished(tupleTemp, start, current);
        }
    }
}

