/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.util;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;

public class ClasspathAnnotationScanner {
    private ClasspathAnnotationScanner() {
    }

    public static <K, T extends Annotation> Map<Class<?>, T> find(Class<K> parent, Class<T> targetAnnotation) {
        return ClasspathAnnotationScanner.find(parent, targetAnnotation, "");
    }

    public static <K, T extends Annotation> Map<Class<?>, T> find(Class<K> parent, Class<T> targetAnnotation, String ... packageName) {
        ArrayList urls = new ArrayList();
        if (packageName != null && packageName.length > 0) {
            String[] stringArray = packageName;
            int n = packageName.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                urls.addAll(ClasspathHelper.forPackage((String)name, (ClassLoader[])new ClassLoader[0]));
                ++n2;
            }
        }
        Reflections reflections = new Reflections(new Object[]{urls, Scanners.TypesAnnotated});
        Set annotated = reflections.getTypesAnnotatedWith(targetAnnotation);
        HashMap<Class, T> map = new HashMap<Class, T>();
        for (Class clazz : annotated) {
            T code = clazz.getAnnotation(targetAnnotation);
            if (parent != null && !parent.isAssignableFrom(clazz) || code == null) continue;
            map.put(clazz, code);
        }
        return map;
    }
}

