/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.digester;

import com.meidusa.toolkit.common.util.StringUtil;
import com.meidusa.venus.util.VenusBeanUtilsBean;
import java.beans.PropertyDescriptor;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public class BeanPropertySetterRule
extends org.apache.commons.digester.BeanPropertySetterRule {
    protected static Log log = LogFactory.getLog((String)"org.apache.commons.digester.Digester");
    protected static ThreadLocal<ArrayStack> threadLocal = new ThreadLocal<ArrayStack>(){

        @Override
        protected ArrayStack initialValue() {
            return new ArrayStack();
        }
    };
    private String attrname;
    private String attrvalue;

    public BeanPropertySetterRule() {
    }

    public BeanPropertySetterRule(String propertyName) {
        super(propertyName);
    }

    public BeanPropertySetterRule(String propertyName, String attrname) {
        super(propertyName);
        this.attrname = attrname;
    }

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        if (this.attrname != null) {
            this.attrvalue = attributes.getValue(this.attrname);
        }
        ArrayStack stack = threadLocal.get();
        stack.push((Object)this.attrvalue);
        super.begin(namespace, name, attributes);
    }

    public void end(String namespace, String name) throws Exception {
        this.propertyName = this.attrvalue;
        this.end0(namespace, name);
        ArrayStack stack = threadLocal.get();
        stack.pop();
    }

    private void end0(String namespace, String name) throws Exception {
        String property = this.propertyName;
        boolean isBasic = false;
        if (property == null) {
            property = name;
        }
        Object top = this.digester.peek();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[BeanPropertySetterRule]{" + this.digester.getMatch() + "} Set " + top.getClass().getName() + " property " + property + " with text " + this.bodyText));
        }
        if (top instanceof DynaBean) {
            DynaProperty desc = ((DynaBean)top).getDynaClass().getDynaProperty(property);
            if (desc == null) {
                throw new NoSuchMethodException("Bean has no property named " + property);
            }
        } else {
            PropertyDescriptor desc = PropertyUtils.getPropertyDescriptor((Object)top, (String)property);
            if (desc == null) {
                throw new NoSuchMethodException("Bean has no property named " + property);
            }
            Class<?> type = desc.getPropertyType();
            isBasic = this.isBasicType(type);
        }
        if (isBasic) {
            VenusBeanUtilsBean.getInstance().setProperty(top, property, (Object)this.bodyText);
        } else if (!StringUtil.isEmpty((String)this.bodyText)) {
            VenusBeanUtilsBean.getInstance().setProperty(top, property, (Object)this.bodyText);
        }
    }

    private Boolean isBasicType(Class clazz) {
        if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || String.class == clazz) {
            return true;
        }
        return false;
    }
}

