/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.util;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class ClasspathAnnotationScanner {
    private ClasspathAnnotationScanner() {
    }

    public static <K, T extends Annotation> Map<Class<?>, T> find(Class<K> parent, Class<T> targetAnnotation) {
        HashMap map = new HashMap();
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(true);
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(targetAnnotation));
        Set set = provider.findCandidateComponents("");
        for (BeanDefinition bean : set) {
            Class<?> clazz;
            try {
                clazz = Class.forName(bean.getBeanClassName());
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            if (!parent.isAssignableFrom(clazz)) continue;
            T code = clazz.getAnnotation(targetAnnotation);
            map.put(clazz, code);
        }
        return map;
    }
}

