package com.meidusa.venus.util;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;

public class ClasspathAnnotationScanner {
    private ClasspathAnnotationScanner(){}
    
    /**
     * 
     * @param parent
     * @param targetAnnotation
     * @return
     */
    public static <K,T extends Annotation> Map<Class<?>,T> find(Class<K> parent,Class<T> targetAnnotation){
        Map<Class<?>,T> map = new HashMap<Class<?>,T>();
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(true);
        provider.addIncludeFilter(new AnnotationTypeFilter(targetAnnotation));
        
        Set<BeanDefinition> set = provider.findCandidateComponents("");
        for(BeanDefinition bean : set){
            Class<?> clazz;
            
            try {
                clazz = Class.forName(bean.getBeanClassName());
            } catch (ClassNotFoundException e) {
                continue;
            }
            
            if(!parent.isAssignableFrom(clazz)){
                continue;
            }
            
            T code = clazz.getAnnotation(targetAnnotation);
            map.put(clazz,code);
        }
        
        return map;
    }
}
