/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.util;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ClasspathAnnotationScanner {
    private ClasspathAnnotationScanner() {
    }

    public static <K, T extends Annotation> Map<Class<?>, T> find(Class<K> parent, Class<T> targetAnnotation) {
        return ClasspathAnnotationScanner.find(parent, targetAnnotation, null);
    }

    public static <K, T extends Annotation> Map<Class<?>, T> find(Class<K> parent, Class<T> targetAnnotation, String packageName) {
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        Set annotated = reflections.getTypesAnnotatedWith(targetAnnotation);
        HashMap<Class, T> map = new HashMap<Class, T>();
        for (Class clazz : annotated) {
            T code = clazz.getAnnotation(targetAnnotation);
            if (parent != null && !parent.isAssignableFrom(clazz) || code == null) continue;
            map.put(clazz, code);
        }
        return map;
    }
}

