/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.spring;

import com.meidusa.toolkit.common.bean.config.ConfigUtil;
import java.io.IOException;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;

public class VenusPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer
implements BeanDefinitionRegistryPostProcessor,
InitializingBean {
    private boolean inited;
    private BeanFactory beanFactory;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.inited) {
            return;
        }
        try {
            Properties mergedProps = this.mergeProperties();
            this.convertProperties(mergedProps);
            this.processProperties(beanFactory, mergedProps);
            this.inited = true;
        }
        catch (IOException ex) {
            throw new BeanInitializationException("Could not load properties", (Throwable)ex);
        }
    }

    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties props) throws BeansException {
        ConfigUtil.addProperties((Properties)props);
        super.processProperties(beanFactory, props);
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.postProcessBeanFactory((ConfigurableListableBeanFactory)this.beanFactory);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        this.postProcessBeanFactory((ConfigurableListableBeanFactory)this.beanFactory);
    }
}

