/**
 * 
 */
package com.meidusa.venus.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * specify service name
 * 
 * @author Sun Ning
 *
 */
@Documented
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface Service {
	
	/**
	 * 榛樿鐨勬湇鍔″悕绉颁负short className
	 * @return
	 */
    String name() default "";
    
    /**
     * 鐢ㄤ簬implement涓嶄负绌虹殑鎯呭喌锛屽疄渚嬪寲implement() 鐩稿叧鐨勭被锛屽苟涓斿喅瀹氭槸鍚︽槸鍗曚緥銆�
     * @return
     */
    boolean singleton() default true;
    
    int version() default 0;
    /**
     * 璇ervice鎺ュ彛鐨勬湰鍦伴粯璁ゅ疄鐜帮紝璇ュ瓧娈典笉涓虹┖锛屽垯浼氶噰鐢╥mplement()杩斿洖鐨勭被鍚嶈繘琛岀浉鍏崇殑鏂规硶璋冪敤
     * @return
     */
    String implement() default "";
    
    String description() default "";
}
