  
package com.meidusa.toolkit.web.page;  
   
import org.apache.struts2.components.UIBean;    
import org.apache.struts2.views.annotations.StrutsTag;    
import org.apache.struts2.views.annotations.StrutsTagAttribute;    
import com.opensymphony.xwork2.util.ValueStack;    
   
import javax.servlet.http.HttpServletRequest;    
import javax.servlet.http.HttpServletResponse;    
   
/**   
 * struts2ķҳǩ   
 *    
 */   
   
@StrutsTag(name = "pager", tldTagClass = "com.meidusa.pirateweb.web.tag.PagerTag", description = "struts2 pager by ithink")    
public class Pager extends UIBean {    
   
    final public static String TEMPLATE = "pager";    
   
    protected String totalRecord;    
    protected String totalPage;    
    protected String curPage;    
    protected String pageLimit;    
    protected String url;    
    protected String curCssClass;    
    protected String showTotalPage;    
    protected String showTotalRecord;    
    protected String directJumpType;    
   
    public Pager(ValueStack stack, HttpServletRequest request,    
            HttpServletResponse response) {    
        super(stack, request, response);    
    }    
   
    /**   
     * ڷģ֣Struts2Զں.ftlչҵضģļ   
     */   
    @Override   
    protected String getDefaultTemplate() {    
        return TEMPLATE;    
    }    
   
    /**   
     * UIBeanԣһTagмԣм StrutsTagAttributeע⣬˵intͣһҪ   
     *    
     * @param totalPage   
     */   
   
    @StrutsTagAttribute(description = "total records", type = "Long")    
    public void setTotalRecord(String totalRecord) {    
        this.totalRecord = totalRecord;    
    }    
   
    @StrutsTagAttribute(description = "total pages", type = "Integer")    
    public void setTotalPage(String totalPage) {    
        this.totalPage = totalPage;    
    }    
   
    @StrutsTagAttribute(description = "current page", type = "Integer")    
    public void setCurPage(String curPage) {    
        this.curPage = curPage;    
    }    
   
    @StrutsTagAttribute(description = "how many pages in a panel once", type = "Integer")    
    public void setPageLimit(String pageLimit) {    
        this.pageLimit = pageLimit;    
    }    
   
    @StrutsTagAttribute(description = "url to be linked", type = "String")    
    public void setUrl(String url) {    
        this.url = url;    
    }    
   
    @StrutsTagAttribute(description = "css style of current page", type = "String")    
    public void setCurCssClass(String curCssClass) {    
        this.curCssClass = curCssClass;    
    }    
   
    @StrutsTagAttribute(description = "whether to show totalPage", type = "Boolean", defaultValue = "true")    
    public void setShowTotalPage(String showTotalPage) {    
        this.showTotalPage = showTotalPage;    
    }    
   
    @StrutsTagAttribute(description = "whether to show currentPage", type = "Boolean", defaultValue = "false")    
    public void setShowTotalRecord(String showTotalRecord) {    
        this.showTotalRecord = showTotalRecord;    
    }    
   
    // TODO ֱҳת    
    // directJumpTypeĬֵΪnone ѡֵΪ 'select', 'goto'    
    @StrutsTagAttribute(description = "show type of direct jump type. such as select,textbox which can lead going to a page directly", type = "String", defaultValue = "none")    
    public void setDirectJumpType(String directJumpType) {    
        this.directJumpType = directJumpType;    
    }    
   
    /**   
     * дevaluateExtraParamsUIBeanʼʼ趨addParameterfreemarkerparametersһkey   
     * valueҪעfindStringصfindxxxxѾװ˵Ľognl﷨ĹߣôģҿԲ鿴һUIBeanapi   
     * doc   
     */   
    @Override   
    protected void evaluateExtraParams() {    
        super.evaluateExtraParams();    
        // findValue()ѶOGNL˴    
   
        if (totalRecord != null) {    
            addParameter("totalRecord", findValue(totalRecord));    
        }    
   
        if (totalPage != null) {    
            addParameter("totalPage", findValue(totalPage));    
        }    
   
        if (curPage != null) {    
            addParameter("curPage", findValue(curPage));    
        }    
   
        if (pageLimit != null) {    
            addParameter("pageLimit", findValue(pageLimit));    
        }    
   
        if (url != null) {    
            addParameter("url", findValue(url, String.class));    
        }    
   
        if (curCssClass != null) {    
            addParameter("curCssClass", findValue(curCssClass,String.class));    
        }    
   
        if (showTotalPage != null) {    
            addParameter("showTotalPage", findValue(showTotalPage,    
                    Boolean.class));    
        }    
   
        if (showTotalRecord != null) {    
            addParameter("showTotalRecord", findValue(showTotalRecord,Boolean.class));    
        }    
   
        if (directJumpType != null) {    
            addParameter("directJumpType", findValue(directJumpType));    
        }    
   
    }    
} 