/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.web.struts2.cookie;

import com.meidusa.toolkit.web.cookie.ClientCookie;
import com.meidusa.toolkit.web.cookie.ClientCookieAware;
import com.meidusa.toolkit.web.cookie.ClientCookieFactory;
import com.meidusa.toolkit.web.cookie.ClientCookieNotCare;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCookieInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(ClientCookieInterceptor.class);

    public void init() {
        super.init();
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        ClientCookie cookie = null;
        HttpServletRequest request = ServletActionContext.getRequest();
        try {
            cookie = ClientCookieFactory.getInstance().readCookie(request);
        }
        catch (Exception e) {
            logger.error("mapping cookie error", (Throwable)e);
            return this.redirect();
        }
        ClientCookieNotCare notcare = (ClientCookieNotCare)ClientCookieInterceptor.getAnnotation(invocation.getAction().getClass().getDeclaredAnnotations(), ClientCookieNotCare.class);
        if (notcare == null && !cookie.isValid()) {
            return this.redirect();
        }
        if (invocation.getAction() instanceof ClientCookieAware) {
            ClientCookieAware cookieAware = (ClientCookieAware)invocation.getAction();
            cookieAware.setClientCookie(cookie);
        }
        request.setAttribute("clientCookie", (Object)cookie);
        if (notcare != null && cookie != null && cookie.getCookieMask() != null) {
            cookie.update();
        }
        return invocation.invoke();
    }

    protected String redirect() throws IOException {
        HttpServletRequest request = ServletActionContext.getRequest();
        String redirectUrl = ClientCookieFactory.getInstance().getRedirectUrl(request);
        ServletActionContext.getResponse().sendRedirect(redirectUrl);
        return "none";
    }

    public static <T> T getAnnotation(Annotation[] annotaions, Class<? extends Annotation> T) {
        int i = 0;
        while (i < annotaions.length) {
            if (annotaions[i].annotationType().equals(T)) {
                return (T)annotaions[i];
            }
            ++i;
        }
        return null;
    }
}

