/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.web.struts2.checkcode;

import com.opensymphony.xwork2.ActionInvocation;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.dispatcher.StrutsResultSupport;

public class CheckCodeResultType
extends StrutsResultSupport {
    protected String contentType = "image/jpeg";
    protected int contentLength;
    private String checkCode;

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        HttpServletResponse oResponse = (HttpServletResponse)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        oResponse.setHeader("Pragma", "No-cache");
        oResponse.setHeader("Cache-Control", "no-cache");
        oResponse.setDateHeader("Expires", 0L);
        oResponse.setContentType(this.conditionalParse(this.contentType, invocation));
        if (this.contentLength != 0) {
            oResponse.setContentLength(this.contentLength);
        }
        ServletOutputStream oOutput = oResponse.getOutputStream();
        String rand = this.conditionalParse(this.checkCode, invocation);
        int width = 60;
        int height = 24;
        if (rand != null) {
            width = 17 * rand.length();
        }
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics g = image.getGraphics();
        Random random = new Random();
        g.setColor(this.getRandColor(200, 250));
        g.fillRect(0, 0, width, height);
        Font font = new Font("Times New Roman", 1, 20);
        g.setFont(font);
        g.setColor(this.getRandColor(20, 50));
        g.drawRect(0, 0, width - 1, height - 1);
        g.setColor(this.getRandColor(160, 200));
        int i = 0;
        while (i < 155) {
            int x = random.nextInt(width);
            int y = random.nextInt(height);
            int xl = random.nextInt(12);
            int yl = random.nextInt(12);
            g.drawLine(x, y, x + xl, y + yl);
            ++i;
        }
        if (rand != null) {
            i = 0;
            while (i < rand.length()) {
                g.setColor(new Color(20 + random.nextInt(110), 20 + random.nextInt(110), 20 + random.nextInt(110)));
                g.drawString(String.valueOf(rand.charAt(i)), 15 * i + 7, 17);
                ++i;
            }
        }
        g.dispose();
        ImageIO.write((RenderedImage)image, "JPEG", (OutputStream)oResponse.getOutputStream());
        oOutput.flush();
    }

    private Color getRandColor(int fc, int bc) {
        Random random = new Random();
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }

    public String getCheckCode() {
        return this.checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }
}

