package com.meidusa.toolkit.web.struts2.checkcode;

import com.meidusa.toolkit.web.checkcode.CheckCodeSession;
import com.meidusa.toolkit.web.checkcode.CheckCodeSessionAware;
import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.FieldValidatorSupport;







import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckCodeValidator extends FieldValidatorSupport {
	private static Logger logger = LoggerFactory.getLogger(CheckCodeValidator.class);
	
	public void validate(Object object) throws ValidationException {
		Object obj = getFieldValue(getFieldName(), object);
		CheckCodeSession checkCodeSession = null;
		
		if(object instanceof CheckCodeSessionAware){
			checkCodeSession = ((CheckCodeSessionAware)object).getCheckCodeSession();
			if(checkCodeSession == null){
				logger.error("action: "+ object +" not implements CheckCodeSessionAware.class");
			}
		}
		
		String checkCode = (String) obj;
		if(StringUtils.isEmpty(checkCode) || checkCodeSession == null || !checkCodeSession.isValidate()){
			this.addFieldError(getFieldName(), object);
		}else{
			if(checkCode.equalsIgnoreCase(checkCodeSession.getCheckCode())){
				checkCodeSession.setValidate(false);
			}else{
				this.addFieldError(getFieldName(), object);
			}
		}
	}
}