package com.meidusa.toolkit.web.struts2.checkcode;

import java.util.Random;

import com.meidusa.toolkit.web.checkcode.CheckCodeSession;
import com.meidusa.toolkit.web.checkcode.CheckCodeSessionAware;
import com.opensymphony.xwork2.Action;

/**
 * 
 * @author struct
 * @version $Id: CheckCodeAction.java,v 1.4 2007/04/12 08:41:18 struct Exp $
 */
public class CheckCodeAction implements Action,CheckCodeSessionAware {

	private static final long serialVersionUID = 1L;
	private String checkCode;
	private CheckCodeSession checkCodeSession;
	private int codeLenght = 4;
	private static char[] codes={'0','1','2','3','4','5','6','7','8','9'};
	public String execute() throws Exception {
		Random random = new Random();
		char[] checkCodeChararray = new char[codeLenght];
		for(int i=0;i<codeLenght;i++){
			checkCodeChararray[i] = codes[random.nextInt(codes.length)];
		}
		checkCode = String.valueOf(checkCodeChararray);
		checkCodeSession.setCheckCode(checkCode);
		
		checkCodeSession.setCreateTime(System.currentTimeMillis());
		checkCodeSession.setValidate(true);
		return SUCCESS;
	}

	public String getCheckCode() {
		return checkCode;
	}

	public void setCheckCodeSession(CheckCodeSession checkCodeSession) {
		this.checkCodeSession = checkCodeSession;
	}

	public void setCodeLenght(int codeLenght) {
		this.codeLenght = codeLenght;
	}

	public CheckCodeSession getCheckCodeSession() {
		return checkCodeSession;
	}
	
	
}