package com.meidusa.toolkit.web.struts2.cookie;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.meidusa.toolkit.web.cookie.ClientCookie;
import com.meidusa.toolkit.web.cookie.ClientCookieAware;
import com.meidusa.toolkit.web.cookie.ClientCookieFactory;
import com.meidusa.toolkit.web.cookie.ClientCookieNotCare;
import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;

/**
 * XworkcookieҪǸȡͻ˵cookiecookieתɶӦóѺõClientCookie,
 * Ҫܵcookieмдͻˣȡʱнܡ
 * 
 * @author Struct
 *
 */
public class ClientCookieInterceptor extends AbstractInterceptor {
	private static final long serialVersionUID = 1L;
	private static Logger logger = LoggerFactory.getLogger(ClientCookieInterceptor.class);
	

	public void init() {
		super.init();
		
    }

	@SuppressWarnings("unchecked")
	@Override
	public String intercept(ActionInvocation invocation) throws Exception {
		ClientCookie cookie = null;
		HttpServletRequest request = ServletActionContext.getRequest();
		try{
			cookie = ClientCookieFactory.getInstance().readCookie(request);
		}catch(Exception e){
			logger.error("mapping cookie error",e);
			return redirect();
		}
		if(!(invocation.getAction() instanceof ClientCookieNotCare)){
			if(!cookie.isValid()){
				return redirect();
			}
		}
		
		if(invocation.getAction() instanceof ClientCookieAware){
			ClientCookieAware cookieAware = (ClientCookieAware)invocation.getAction();
			cookieAware.setClientCookie(cookie);
		}
		request.setAttribute("clientCookie", cookie);
		
		if(!(invocation.getAction() instanceof ClientCookieNotCare)){
			if(cookie != null){
				if(cookie.getCookieMask() != null){
					cookie.update();
				}
			}
		}
		return invocation.invoke();
	}
	
	protected String redirect() throws IOException{
		HttpServletRequest request = ServletActionContext.getRequest();
		String redirectUrl = ClientCookieFactory.getInstance().getRedirectUrl(request);
		ServletActionContext.getResponse().sendRedirect(redirectUrl);
		return Action.NONE;
	}

}
