package com.meidusa.toolkit.web.struts2.checkcode;

import org.apache.struts2.dispatcher.StrutsResultSupport;
import com.opensymphony.xwork2.ActionInvocation;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.util.Random;
/**
 * Implements an XWork Result that takes an InputStream object available from a chained
 * Action and redirects it to the browser.
 *
 * <p/>
 *
 * The following declaration must be added to the xwork.xml file after the &lt;package&gt;
 * element:
 *
 * <p/>
 *
 * <pre>
 * &lt;result-types&gt;
 * &lt;result-type name="stream" class="com.opensymphony.webwork.dispatcher.StreamResult"/&gt;
 * &lt;/result-types&gt;
 * </pre>
 *
 * <p/>
 *
 * To use the stream result type add the following as part of the action declaration:
 *
 * <p/>
 *
 * <pre>
 * &lt;result name="success" type="stream"&gt;
 * &lt;param name="contentType"&gt;image/jpeg&lt/param&gt;
 * &lt;param name="inputName"&gt;imageStream&lt/param&gt;
 * &lt;param name="contentDisposition"&gt;filename="document.pdf"&lt/param&gt;
 * &lt;param name="bufferSize"&gt;1024&lt/param&gt;
 * &lt;/result&gt;
 * </pre>
 *
 * <p/>
 *
 * <ul>
 * <li>contentType - the stream mime-type as sent to the web browser</li>
 * <li>contentLength - the stream length in bytes (the browser displays a progress bar)</li>
 * <li>contentDispostion - the content disposition header value for specifing the file name (default = "inline", values are typically <i>filename="document.pdf"</i></li>
 * <li>inputName - the name of the InputStream property from the chained action (default = "inputStream")</li>
 * <li>bufferSize - the size of the buffer to copy from input to output (defaul = 1024)</li>
 * </ul>
 *
 * @author mcrawford
 */

public class CheckCodeResultType extends StrutsResultSupport{
    protected String contentType = "image/jpeg";
    protected int contentLength;
    private String checkCode;
    
    
    /**
     * @return Returns the contentType.
     */
    public String getContentType() {
        return (contentType);
    }

    /**
     * @param contentType The contentType to set.
     */
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    /**
     * @return Returns the contentLength.
     */
    public int getContentLength() {
        return contentLength;
    }

    /**
     * @param contentLength The contentLength to set.
     */
    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }



    /**
     * @see com.opensymphony.xwork.Result#execute(com.opensymphony.xwork.ActionInvocation)
     */
    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        try {
            // Find the Response in context
            HttpServletResponse oResponse = (HttpServletResponse) invocation.getInvocationContext().get(HTTP_RESPONSE);
            oResponse.setHeader("Pragma","No-cache");
            oResponse.setHeader("Cache-Control","no-cache");
            oResponse.setDateHeader("Expires", 0);

            // Set the content type
            oResponse.setContentType(conditionalParse(contentType, invocation));

            // Set the content length
            if (contentLength != 0) {
                 oResponse.setContentLength(contentLength);
            }
            // Get the outputstream
            OutputStream oOutput = oResponse.getOutputStream();
            
            //ȡ֤(4λ)
            String rand=conditionalParse(checkCode, invocation);
            
//          ڴдͼ
            int width=60, height=24;
            if(rand!= null){
            	width = 17 * rand.length();
            }
            BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);

//             ȡͼ
            Graphics g = image.getGraphics();

//            
            Random random = new Random();

//             趨ɫ
            g.setColor(getRandColor(200,250));
            g.fillRect(0, 0, width, height);

//            趨
            Font font = new Font("Times New Roman",Font.BOLD,20);
            g.setFont(font);

//            ߿
            g.setColor(getRandColor(20,50));
            g.drawRect(0,0,width-1,height-1);


//             155ߣʹͼе֤벻ױ̽⵽
            g.setColor(getRandColor(160,200));
            for (int i=0;i<155;i++)
            {
             int x = random.nextInt(width);
             int y = random.nextInt(height);
                    int xl = random.nextInt(12);
                    int yl = random.nextInt(12);
             g.drawLine(x,y,x+xl,y+yl);
            }
            
            if(rand != null){
	            for (int i=0;i<rand.length();i++){
	                // ֤ʾͼ
	                g.setColor(new Color(20+random.nextInt(110),20+random.nextInt(110),20+random.nextInt(110)));//úɫͬΪ̫ӽֱֻ
	                g.drawString(String.valueOf(rand.charAt(i)),15 * i + 7,17);
	            }
            }

//             ͼЧ
            g.dispose();

//             ͼҳ
            ImageIO.write(image, "JPEG", oResponse.getOutputStream());
            
            // Flush
            oOutput.flush();
        }
        finally {
        	
        }
    }
   private Color getRandColor(int fc,int bc){//Χɫ
        Random random = new Random();
        if(fc>255) fc=255;
        if(bc>255) bc=255;
        int r=fc+random.nextInt(bc-fc);
        int g=fc+random.nextInt(bc-fc);
        int b=fc+random.nextInt(bc-fc);
        return new Color(r,g,b);
        }

	public String getCheckCode() {
		return checkCode;
	}
	
	public void setCheckCode(String checkCode) {
		this.checkCode = checkCode;
	}
}
