/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.util.scanner;

import com.meidusa.toolkit.plugins.autoconfig.util.ZipUtil;
import com.meidusa.toolkit.plugins.autoconfig.util.scanner.AbstractScanner;
import com.meidusa.toolkit.plugins.autoconfig.util.scanner.ScannerException;
import com.meidusa.toolkit.plugins.autoconfig.util.scanner.ScannerHandler;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipScanner
extends AbstractScanner {
    private URL zipURL;
    private ZipInputStream zis;
    private ZipEntry zipEntry;

    public ZipScanner(File zipfile, ScannerHandler handler) {
        super(handler);
        if (!(zipfile.exists() && zipfile.isFile() && zipfile.canRead())) {
            throw new IllegalArgumentException(zipfile + " is not a readable file");
        }
        try {
            this.zipURL = zipfile.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(zipfile + " is not a readable file");
        }
    }

    public ZipScanner(URL zipURL, ScannerHandler handler) {
        super(handler);
        this.zipURL = zipURL;
    }

    @Override
    public URL getBaseURL() {
        return this.zipURL;
    }

    @Override
    public URL getURL() {
        try {
            return ZipUtil.getJarURL(this.getBaseURL(), this.getPath());
        }
        catch (MalformedURLException e) {
            throw new ScannerException(e);
        }
    }

    @Override
    public InputStream getInputStream() {
        return new FilterInputStream(this.zis){

            @Override
            public void close() throws IOException {
            }
        };
    }

    public void setInputStream(InputStream istream) {
        if (istream != null) {
            this.zis = new ZipInputStream(istream);
        }
    }

    public ZipEntry getZipEntry() {
        return this.zipEntry;
    }

    @Override
    public void scan() {
        this.getScannerHandler().setScanner(this);
        this.getScannerHandler().startScanning();
        boolean needClose = false;
        if (this.zis == null) {
            try {
                this.zis = new ZipInputStream(this.getBaseURL().openStream());
                needClose = true;
            }
            catch (IOException e) {
                throw new ScannerException(e);
            }
        }
        try {
            this.doScan();
        }
        finally {
            if (needClose) {
                try {
                    this.zis.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.getScannerHandler().endScanning();
    }

    protected void doScan() {
        try {
            while ((this.zipEntry = this.zis.getNextEntry()) != null) {
                String savedPath = this.setPath(this.zipEntry.getName());
                if (this.zipEntry.isDirectory()) {
                    this.getScannerHandler().directory();
                } else {
                    this.getScannerHandler().file();
                }
                this.setPath(savedPath);
            }
        }
        catch (IOException e) {
            System.err.println("WARING! Failed to get ZipEntry");
            e.printStackTrace();
        }
    }
}

