/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.generator;

import com.meidusa.toolkit.plugins.autoconfig.ConfigException;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigDescriptor;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigGenerate;
import com.meidusa.toolkit.plugins.autoconfig.generator.ConfigGenerator;
import com.meidusa.toolkit.plugins.autoconfig.generator.ConfigGeneratorCallback;
import com.meidusa.toolkit.plugins.autoconfig.generator.PropertiesLoader;
import com.meidusa.toolkit.plugins.autoconfig.generator.VelocityTemplateEngine;
import com.meidusa.toolkit.plugins.autoconfig.util.i18n.LocaleInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.velocity.context.Context;

public class ConfigGeneratorSession {
    protected final ConfigGenerator generator;
    protected final Map props;
    private final Map descriptorLogs;
    private final Set processedDestfiles;
    private ConfigGenerate currentGenerate;
    private InputStream currentInputStream;
    private OutputStream currentOutputStream;
    private ConfigDescriptor[] configDescriptors;

    protected ConfigGeneratorSession(ConfigGenerator generator, File propertiesFile, String propertiesFileCharset) {
        this.generator = generator;
        this.props = new HashMap();
        this.descriptorLogs = new HashMap();
        this.processedDestfiles = new HashSet();
        PropertiesLoader.mergeProperties(this.props, PropertiesLoader.loadPropertiesFile(propertiesFile, propertiesFileCharset));
        PropertiesLoader.mergeProperties(this.props, System.getProperties());
        ConfigDescriptor[] descriptors = generator.getConfigDescriptors();
        Date now = new Date();
        int i = 0;
        while (i < descriptors.length) {
            ConfigDescriptor descriptor = descriptors[i];
            String descriptorName = descriptor.getName();
            StringWriter logBuffer = new StringWriter();
            PrintWriter log = new PrintWriter((Writer)logBuffer, true);
            this.descriptorLogs.put(descriptorName, new Object[]{logBuffer, log, descriptor});
            log.println("Last Configured at: " + now);
            log.println();
            log.println("Base URL: " + descriptor.getBaseURL());
            log.println("Descriptor: " + descriptorName);
            log.println();
            ++i;
        }
    }

    public void setInputStream(InputStream istream) {
        this.currentInputStream = istream;
    }

    public void setOutputStream(OutputStream ostream) {
        this.currentOutputStream = ostream;
    }

    public Context getVelocityContext() {
        if (this.currentGenerate == null) {
            throw new IllegalStateException("Have not call nextEntry method yet");
        }
        final HashMap descriptorProps = new HashMap(this.props);
        PropertiesLoader.mergeProperties(descriptorProps, this.currentGenerate.getConfigDescriptor().getContext());
        return new Context(){

            public Object put(String key, Object value) {
                Object oldValue = this.get(key);
                descriptorProps.put(key, value);
                return oldValue;
            }

            public Object get(String key) {
                return PropertiesLoader.evaluate(key, descriptorProps);
            }

            public boolean containsKey(Object key) {
                return descriptorProps.containsKey(key);
            }

            public Object[] getKeys() {
                Set keySet = descriptorProps.keySet();
                return keySet.toArray(new Object[keySet.size()]);
            }

            public Object remove(Object key) {
                Object oldValue = this.get(String.valueOf(key));
                descriptorProps.remove(key);
                return oldValue;
            }
        };
    }

    public void generate(ConfigGeneratorCallback callback) {
        for (String template : this.generator.generateTemplateFiles.keySet()) {
            this.generate(template, callback);
        }
    }

    public void generate(String template, ConfigGeneratorCallback callback) {
        List generates = (List)this.generator.generateTemplateFiles.get(template);
        if (generates == null || generates.isEmpty()) {
            throw new ConfigException("No defined template " + template);
        }
        Iterator i = generates.iterator();
        while (i.hasNext()) {
            try {
                this.currentGenerate = (ConfigGenerate)i.next();
                callback.nextEntry(this.currentGenerate.getConfigDescriptor(), this.currentGenerate.getTemplate(), this.currentGenerate.getDestfile());
                if (this.currentInputStream == null || this.currentOutputStream == null) {
                    throw new IllegalStateException("InputStream/OutputStream has not been set");
                }
                this.processedDestfiles.add(this.currentGenerate.getDestfile());
                this.generate(this.currentGenerate, this.currentInputStream, this.currentOutputStream);
            }
            finally {
                try {
                    callback.closeEntry();
                }
                finally {
                    this.currentGenerate = null;
                    this.currentInputStream = null;
                    this.currentOutputStream = null;
                }
            }
        }
    }

    private void generate(ConfigGenerate generate, InputStream istream, OutputStream ostream) {
        String charset = generate.getCharset();
        String outputCharset = generate.getOutputCharset();
        PrintWriter descriptorLog = (PrintWriter)((Object[])this.descriptorLogs.get(generate.getConfigDescriptor().getName()))[1];
        BufferedReader reader = null;
        Writer writer = null;
        try {
            try {
                reader = new BufferedReader(new InputStreamReader(istream, charset)){

                    @Override
                    public void close() throws IOException {
                    }
                };
                writer = new BufferedWriter(new OutputStreamWriter(ostream, outputCharset)){

                    @Override
                    public void close() throws IOException {
                    }
                };
                descriptorLog.println("Generating " + generate.getTemplate() + " => " + generate.getDestfile());
                this.generator.configSettings.info("<" + generate.getConfigDescriptor().getBaseURL() + ">\n    Generating " + generate.getTemplate() + " => " + generate.getDestfile() + "\n");
                VelocityTemplateEngine.getInstance().render(this.getVelocityContext(), reader, writer);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new ConfigException(e);
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void generateLog(ConfigGeneratorCallback callback) {
        Iterator i = this.descriptorLogs.values().iterator();
        while (i.hasNext()) {
            try {
                Object[] logPair = (Object[])i.next();
                StringWriter logBuffer = (StringWriter)logPair[0];
                PrintWriter log = (PrintWriter)logPair[1];
                ConfigDescriptor descriptor = (ConfigDescriptor)logPair[2];
                String logfile = this.generator.getDescriptorLogFile(descriptor);
                callback.logEntry(descriptor, logfile);
                String logContent = logBuffer.toString();
                Writer writer = null;
                try {
                    try {
                        writer = new BufferedWriter(new OutputStreamWriter(this.currentOutputStream, LocaleInfo.getDefault().getCharset())){

                            @Override
                            public void close() throws IOException {
                            }
                        };
                        this.generator.configSettings.info("<" + descriptor.getBaseURL() + ">\n    Generating log file: " + logfile + "\n");
                        writer.write(logContent);
                    }
                    catch (IOException e) {
                        throw new ConfigException(e);
                    }
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.flush();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            finally {
                callback.closeEntry();
                this.currentGenerate = null;
                this.currentInputStream = null;
                this.currentOutputStream = null;
            }
        }
    }

    public void checkNonprocessedTemplates() {
        for (String destfile : this.generator.generateDestFiles.keySet()) {
            if (this.processedDestfiles.contains(destfile)) continue;
            ConfigGenerate generate = (ConfigGenerate)this.generator.generateDestFiles.get(destfile);
            String template = generate.getTemplate();
            throw new ConfigException("Could not find template file: " + template + " for descriptor: " + generate.getConfigDescriptor().getURL());
        }
    }

    public void close() {
    }
}

