/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.generator;

import com.meidusa.toolkit.plugins.autoconfig.ConfigException;
import com.meidusa.toolkit.plugins.autoconfig.ConfigResource;
import com.meidusa.toolkit.plugins.autoconfig.ConfigSettings;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigDescriptor;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigDescriptorLoader;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigGenerate;
import com.meidusa.toolkit.plugins.autoconfig.generator.ConfigGeneratorSession;
import com.meidusa.toolkit.plugins.autoconfig.util.FileUtil;
import com.meidusa.toolkit.plugins.autoconfig.util.StringUtil;
import com.meidusa.toolkit.plugins.autoconfig.util.i18n.LocaleInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ConfigGenerator {
    final ConfigSettings configSettings;
    private List configDescriptors = new LinkedList();
    Map generateTemplateFiles = new HashMap();
    Map generateDestFiles = new HashMap();
    private ConfigGeneratorSession session;
    private boolean initialized = false;

    public ConfigGenerator(ConfigSettings logger) {
        this.configSettings = logger;
    }

    public ConfigDescriptor addConfigDescriptor(ConfigResource descriptorResource) {
        URL descriptorURL = descriptorResource.getURL();
        InputStream istream = null;
        try {
            istream = descriptorURL.openStream();
            if (!(istream instanceof BufferedInputStream)) {
                istream = new BufferedInputStream(istream, 8192);
            }
            ConfigDescriptor configDescriptor = this.addConfigDescriptor(descriptorResource, istream);
            return configDescriptor;
        }
        catch (IOException e) {
            throw new ConfigException(e);
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public ConfigDescriptor addConfigDescriptor(ConfigResource descriptorResource, InputStream istream) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot add config descriptors after initialization");
        }
        ConfigDescriptorLoader loader = new ConfigDescriptorLoader();
        ConfigDescriptor descriptor = loader.load(descriptorResource, istream);
        this.configDescriptors.add(descriptor);
        return descriptor;
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        for (ConfigDescriptor descriptor : this.configDescriptors) {
            String basename = String.valueOf(descriptor.getName()) + "/../";
            int j = 0;
            while (j < descriptor.getGenerates().length) {
                ConfigGenerate generate = descriptor.getGenerates()[j];
                String charset = generate.getCharset();
                String outputCharset = generate.getOutputCharset();
                if (charset == null) {
                    charset = LocaleInfo.getDefault().getCharset();
                }
                if (outputCharset == null) {
                    outputCharset = charset;
                }
                generate.setCharset(charset);
                generate.setOutputCharset(outputCharset);
                String template = generate.getTemplate();
                String destFile = generate.getDestfile();
                if (StringUtil.isBlank(template)) {
                    this.configSettings.warn("Missing template attribute in <generate>: file=" + descriptor.getURL());
                    descriptor.removeGenerate(generate);
                } else if (StringUtil.isBlank(destFile)) {
                    this.configSettings.warn("Missing destfile attribute in <generate>: file=" + descriptor.getURL());
                    descriptor.removeGenerate(generate);
                } else {
                    template = FileUtil.normalizeUnixPath(String.valueOf(basename) + template);
                    destFile = FileUtil.normalizeUnixPath(destFile);
                    generate.setTemplate(template);
                    generate.setDestfile(destFile);
                    if (this.generateDestFiles.containsKey(destFile)) {
                        ConfigGenerate originalGenerate = (ConfigGenerate)this.generateDestFiles.get(destFile);
                        if (originalGenerate.getConfigDescriptor() == descriptor) {
                            this.configSettings.info("Duplicated destfile " + destFile + "\n  in " + descriptor.getURL());
                        } else {
                            this.configSettings.info("Duplicated destfile " + destFile + "\n  in  " + descriptor.getURL() + "\n  and " + originalGenerate.getConfigDescriptor().getURL());
                        }
                        descriptor.removeGenerate(generate);
                    } else {
                        this.generateDestFiles.put(destFile, generate);
                        LinkedList<ConfigGenerate> generates = (LinkedList<ConfigGenerate>)this.generateTemplateFiles.get(template);
                        if (generates == null) {
                            generates = new LinkedList<ConfigGenerate>();
                            this.generateTemplateFiles.put(template, generates);
                        }
                        generates.add(generate);
                    }
                }
                ++j;
            }
        }
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Cannot call this method before initialization");
        }
    }

    public ConfigDescriptor[] getConfigDescriptors() {
        this.ensureInitialized();
        return this.configDescriptors.toArray(new ConfigDescriptor[this.configDescriptors.size()]);
    }

    public boolean isTemplateFile(String template) {
        this.ensureInitialized();
        return this.generateTemplateFiles.containsKey(template);
    }

    public boolean isDestFile(String destfile) {
        this.ensureInitialized();
        return this.generateDestFiles.containsKey(destfile);
    }

    public String getDescriptorLogFile(ConfigDescriptor descriptor) {
        return String.valueOf(descriptor.getName()) + ".log";
    }

    public boolean isDescriptorLogFile(String name) {
        this.ensureInitialized();
        for (ConfigDescriptor descriptor : this.configDescriptors) {
            if (!this.getDescriptorLogFile(descriptor).equals(name)) continue;
            return true;
        }
        return false;
    }

    public ConfigGeneratorSession getSession() {
        this.ensureInitialized();
        if (this.session == null) {
            throw new IllegalStateException("ConfigGeneratorSession has not yet been initialized");
        }
        return this.session;
    }

    public ConfigGeneratorSession startSession(File propertiesFile, String propertiesFileCharset) {
        this.ensureInitialized();
        this.session = new ConfigGeneratorSession(this, propertiesFile, propertiesFileCharset);
        return this.session;
    }

    public void closeSession() {
        this.ensureInitialized();
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }
}

