/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.descriptor.validator;

import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigValidator;
import com.meidusa.toolkit.plugins.autoconfig.util.StringUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class HostExistValidator
extends ConfigValidator {
    private static final Logger log = Logger.getLogger(HostExistValidator.class);
    private String hostname;

    @Override
    public Logger getLogger() {
        return log;
    }

    @Override
    public boolean validate(String value) {
        if (value == null) {
            return true;
        }
        if (StringUtil.isEmpty(value = value.trim())) {
            return true;
        }
        this.getLogger().info((Object)("Validating host name or IP address: " + value));
        this.hostname = value;
        InetAddress ip = null;
        try {
            ip = InetAddress.getByName(this.hostname);
        }
        catch (UnknownHostException e) {
            return false;
        }
        return true;
    }

    @Override
    protected String getDefaultMessage() {
        return "\u975e\u6cd5\u7684\u57df\u540d\u6216IP\uff1a" + this.hostname;
    }
}

