/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig;

import com.meidusa.toolkit.common.bean.config.ConfigUtil;
import com.meidusa.toolkit.plugins.autoconfig.ConfigException;
import com.meidusa.toolkit.plugins.autoconfig.ConfigResource;
import com.meidusa.toolkit.plugins.autoconfig.ConfigRuntime;
import com.meidusa.toolkit.plugins.autoconfig.ConfigSettings;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigDescriptor;
import com.meidusa.toolkit.plugins.autoconfig.entry.ConfigEntry;
import com.meidusa.toolkit.plugins.autoconfig.entry.ConfigEntryFactory;
import com.meidusa.toolkit.plugins.autoconfig.entry.ConfigEntryFactoryImpl;
import com.meidusa.toolkit.plugins.autoconfig.util.FileUtil;
import com.meidusa.toolkit.plugins.autoconfig.util.PatternSet;
import com.meidusa.toolkit.plugins.autoconfig.util.StringUtil;
import com.meidusa.toolkit.plugins.autoconfig.wizard.text.ConfigWizardLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ConfigRuntimeImpl
implements ConfigRuntime {
    private BufferedReader in;
    private PrintWriter out;
    private PrintWriter err;
    private String charset;
    private String mode;
    private String interactiveMode = "auto";
    private PatternSet descriptorPatterns;
    private PatternSet packagePatterns;
    private String[] dests;
    private File[] destFiles;
    private List<File> dependencyFiles;
    private File userPropertiesFile;
    private String userPropertiesFileCharset;
    private Map userProperties;
    private boolean verbose;
    private File tempdir;
    private String projectName;
    private Properties properties;
    private File projectPath;
    private ConfigEntryFactory configEntryFactory = new ConfigEntryFactoryImpl(this);

    public void setProjectPath(File projectPath) {
        this.projectPath = projectPath;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public ConfigRuntimeImpl() {
        this(System.in, System.out, System.err, null);
    }

    public ConfigRuntimeImpl(InputStream inputStream, OutputStream outStream, OutputStream errStream, String charset) {
        this.charset = StringUtil.isEmpty(charset) ? "GBK" : charset;
        try {
            this.in = new BufferedReader(new InputStreamReader(inputStream, this.charset));
            this.out = new PrintWriter((Writer)new OutputStreamWriter(outStream, this.charset), true);
            this.err = new PrintWriter((Writer)new OutputStreamWriter(errStream, this.charset), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new ConfigException(e);
        }
    }

    @Override
    public BufferedReader getIn() {
        return this.in;
    }

    @Override
    public PrintWriter getOut() {
        return this.out;
    }

    @Override
    public PrintWriter getErr() {
        return this.err;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public PatternSet getDescriptorPatterns() {
        return this.descriptorPatterns;
    }

    @Override
    public PatternSet getPackagePatterns() {
        return this.packagePatterns;
    }

    @Override
    public String getInteractiveMode() {
        return this.interactiveMode;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public File[] getDestFiles() {
        return this.destFiles;
    }

    @Override
    public File getUserPropertiesFile() {
        return this.userPropertiesFile;
    }

    @Override
    public String getUserPropertiesFileCharset() {
        return this.userPropertiesFileCharset;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public ConfigEntryFactory getConfigEntryFactory() {
        return this.configEntryFactory;
    }

    public void setDescriptorPatterns(String includes, String excludes) {
        this.descriptorPatterns = new PatternSet(includes, excludes);
    }

    public void setDescriptorPatterns(String[] includes, String[] excludes) {
        this.descriptorPatterns = new PatternSet(includes, excludes);
    }

    public void setPackagePatterns(String includes, String excludes) {
        this.packagePatterns = new PatternSet(includes, excludes);
    }

    public void setPackagePatterns(String[] includes, String[] excludes) {
        this.packagePatterns = new PatternSet(includes, excludes);
    }

    public void setInteractiveMode(String mode) {
        if ("auto".equals(mode) || "on".equals(mode) || "off".equals(mode)) {
            this.interactiveMode = mode;
        }
    }

    public void setGuiMode() {
        this.mode = "gui";
    }

    public void setTextMode() {
        this.mode = "text";
    }

    public void setDests(String[] dests) {
        this.dests = dests;
    }

    public void setUserPropertiesFile(String userPropertiesFile, String charset) {
        String basedir = new File("").getAbsolutePath();
        this.userPropertiesFile = new File(FileUtil.getPathBasedOn(basedir, userPropertiesFile));
        this.userPropertiesFileCharset = charset;
        File directory = this.userPropertiesFile.getParentFile();
        if (!directory.exists()) {
            this.info("directory " + directory.getAbsolutePath() + " does not exists.");
            this.info("directory " + directory.getAbsolutePath() + " is created.");
            if (!directory.mkdirs()) {
                this.info("can't make directory.");
            }
        }
        this.info("set defined properties: " + this.userPropertiesFile.getAbsolutePath() + "\n");
    }

    public void setVerbose() {
        this.verbose = true;
    }

    private void init() {
        if (this.tempdir == null) {
            this.tempdir = new File("");
        }
        this.tempdir = this.tempdir.getAbsoluteFile();
        this.dests = StringUtil.trimStringArray(this.dests);
        if (this.dests.length > 0) {
            this.destFiles = new File[this.dests.length];
            int i = 0;
            while (i < this.dests.length) {
                this.destFiles[i] = new File(ConfigUtil.filter((String)this.dests[i], (Properties)this.properties)).getAbsoluteFile();
                ++i;
            }
        } else {
            this.destFiles = this.getProjectPath() == null ? new File[]{new File("").getAbsoluteFile()} : new File[]{this.getProjectPath()};
        }
        if (this.userPropertiesFile == null) {
            this.userPropertiesFile = new File(System.getProperty("user.home"), String.valueOf(this.getProjectName() == null ? "maven" : this.getProjectName()) + ".properties");
        }
        this.userPropertiesFile = this.userPropertiesFile.getAbsoluteFile();
        this.info("User-defined properties: " + this.userPropertiesFile.getAbsolutePath() + "\n");
    }

    @Override
    public void debug(String message) {
        if (this.verbose) {
            this.getOut().println(message);
        }
    }

    @Override
    public void info(String message) {
        this.getOut().println(message);
    }

    @Override
    public void warn(String message) {
        this.getOut().println(message);
    }

    @Override
    public void error(String message) {
        this.error(message, null);
    }

    @Override
    public void error(Throwable cause) {
        this.error(null, cause);
    }

    @Override
    public void error(String message, Throwable cause) {
        if (StringUtil.isBlank(message) && cause != null) {
            message = "ERROR: " + cause.getMessage();
        }
        this.getErr().println(message);
        if (this.verbose) {
            cause.printStackTrace(this.getErr());
            this.getErr().println();
        }
    }

    @Override
    public void start() {
        this.start(null);
    }

    public void start(ConfigDescriptor inlineDescriptor) {
        this.init();
        if (inlineDescriptor == null) {
            ConfigEntry entry2;
            ArrayList<ConfigEntry> entries = new ArrayList<ConfigEntry>(this.destFiles.length);
            int i = 0;
            while (i < this.destFiles.length) {
                File destFile = this.destFiles[i];
                entry2 = this.getConfigEntryFactory().create(new ConfigResource(destFile));
                entry2.scan();
                if (!entry2.isEmpty()) {
                    entries.add(entry2);
                }
                ++i;
            }
            i = 0;
            while (i < this.dependencyFiles.size()) {
                File dependencyFile = this.dependencyFiles.get(i);
                entry2 = this.getConfigEntryFactory().create(new ConfigResource(dependencyFile));
                entry2.scan();
                if (!entry2.isEmpty()) {
                    entries.add(entry2);
                }
                ++i;
            }
            if (entries.isEmpty()) {
                this.info("Nothing to configure");
                return;
            }
            ConfigWizardLoader wizard = new ConfigWizardLoader((ConfigSettings)this, entries);
            wizard.loadAndStart();
            for (ConfigEntry entry2 : entries) {
                entry2.generate();
            }
        } else {
            ConfigWizardLoader wizard = new ConfigWizardLoader((ConfigSettings)this, inlineDescriptor);
            wizard.loadAndStart();
        }
    }

    @Override
    public File getProjectPath() {
        return this.projectPath;
    }

    public List<File> getDependencyFiles() {
        return this.dependencyFiles;
    }

    public void setDependencyFiles(List<File> dependencyFiles) {
        this.dependencyFiles = dependencyFiles;
    }
}

