package com.meidusa.toolkit.plugins.autoconfig.wizard.text;

import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigDescriptor;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigGroup;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigProperty;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigValidator;
import com.meidusa.toolkit.plugins.autoconfig.generator.PropertiesLoader;
import com.meidusa.toolkit.plugins.autoconfig.generator.expr.CompositeExpression;
import com.meidusa.toolkit.plugins.autoconfig.generator.expr.Expression;
import com.meidusa.toolkit.plugins.autoconfig.generator.expr.ExpressionContext;
import com.meidusa.toolkit.plugins.autoconfig.util.ObjectUtil;
import com.meidusa.toolkit.plugins.autoconfig.util.StringUtil;
import com.meidusa.toolkit.plugins.autoconfig.util.i18n.LocaleInfo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

import java.text.BreakIterator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/**
 * ıĽļĹࡣ
 * 
 * 
 */
public class ConfigWizard {
	private static final int PREVIOUS = -1;
	private static final int NEXT = -2;
	private static final int QUIT = -3;
	private static final int MAX_ALIGN = 40;

	// wizard
	private ConfigDescriptor[] descriptors;
	private ConfigGroup[] groups;
	private File propsFile;
	private String propsCharset;
	private Set keys;
	private Map values;
	private Map encryptInfo;
	private String confirmMessage;
	private BufferedReader in;
	private PrintWriter out;
	private PrintWriter fileWriter;

	// Wizard״̬
	private int step;
	private ConfigGroup group;
	private ConfigProperty[] props;
	private ConfigProperty validatorProperty;
	private String validatorMessage;
	private int validatorIndex;

	/**
	 * һwizard
	 * 
	 * @param descriptors
	 *            ļ
	 * @param propsFile
	 *            ļ
	 * @param propsCharset
	 *            ȡļıַ
	 */
	public ConfigWizard(ConfigDescriptor[] descriptors, File propsFile,
			String propsCharset) {
		this.descriptors = descriptors;
		this.encryptInfo = new HashMap<String, String>();
		this.propsFile = propsFile;
		this.propsCharset = propsCharset = (propsCharset == null) ? LocaleInfo
				.getDefault().getCharset() : propsCharset;

		// ʼ
		try {
			in = new BufferedReader(new InputStreamReader(System.in,
					propsCharset));
			out = new PrintWriter(new OutputStreamWriter(System.out,
					propsCharset), true);
		} catch (UnsupportedEncodingException e) {
			throw new ConfigWizardException(e);
		}

		// װpropsļ
		reloadPropsFile();

		// ȡdescriptorsеgroups
		List groups = new ArrayList();

		for (int i = 0; i < descriptors.length; i++) {
			ConfigGroup[] descriptorGroups = descriptors[i].getGroups();

			for (int j = 0; j < descriptorGroups.length; j++) {
				ConfigGroup group = descriptorGroups[j];
				groups.add(group);
				for (int k = 0; k < group.getProperties().length; k++) {
					ConfigProperty property = group.getProperties()[k];
					if (property.getEncrypt() != null
							&& property.getEncrypt() != "") {
						this.encryptInfo.put(property.getName(),
								property.getEncrypt());
					}

				}
			}
		}

		this.groups = (ConfigGroup[]) groups.toArray(new ConfigGroup[groups
				.size()]);

		// óʼstep
		setStep(0);
	}

	/**
	 * װûpropertiesļ
	 */
	private void reloadPropsFile() {
		Map loadedValues = PropertiesLoader.loadPropertiesFile(propsFile,
				propsCharset);

		this.keys = new HashSet(loadedValues.keySet());
		this.values = new HashMap();

		PropertiesLoader.mergeProperties(this.values, loadedValues);
		PropertiesLoader.mergeProperties(this.values, System.getProperties());
	}

	/**
	 * ȷϢ
	 * 
	 * @param message
	 *            ȷϢ
	 */
	public void setConfirmMessage(String confirmMessage) {
		this.confirmMessage = confirmMessage;
	}

	/**
	 * ֤ļǷdescriptorҪ
	 * 
	 * @return Ҫ򷵻true
	 */
	public boolean validate() {
		for (int i = 0; i < groups.length; i++) {
			setStep(i);

			for (int j = 0; j < props.length; j++) {
				ConfigProperty prop = props[j];

				String value = evaluatePropertyValue(prop, false);

				for (Iterator k = prop.getValidators().iterator(); k.hasNext();) {
					ConfigValidator validator = (ConfigValidator) k.next();

					if (!validator.validate(value)) {
						validatorIndex = j;
						validatorProperty = prop;
						validatorMessage = validator.getMessage();
						return false;
					}
				}
			}
		}

		return true;
	}

	/**
	 * Ĭֵ
	 */
	private void fillDefaultValues() {
		int savedStep = step;

		for (int i = 0; i < groups.length; i++) {
			setStep(i);

			for (int j = 0; j < props.length; j++) {
				ConfigProperty prop = props[j];

				if ((values.get(prop.getName()) == null)
						|| !keys.contains(prop.getName())) {
					String value = getPropertyValue(prop, true);

					setProperty(prop.getName(), (value == null) ? "" : value);
				}
			}
		}

		setStep(savedStep);
	}

	/**
	 * ִwizard
	 */
	public void start() {
		boolean continueWizard = true;

		// ûʲôģֱӷ
		if (group == null) {
			return;
		}

		// ʾû, Ƿ
		if (confirmMessage != null) {
			print(confirmMessage + " [Yes][No] ");

			try {
				String input = in.readLine();

				input = (input == null) ? "" : input.trim().toLowerCase();

				if (input.equals("n") || input.equals("no")) {
					continueWizard = false;
				}
			} catch (IOException e) {
				throw new ConfigWizardException(e);
			}
		}

		println();

		// װĬֵԼûĲ
		if (continueWizard) {
			fillDefaultValues();
		}

		// ʼwizard
		while (continueWizard) {
			// ӡ
			printTitle();

			// ӡgroup
			printGroup();

			// ʾ
			int toStep = processMenu();

			switch (toStep) {
			case PREVIOUS:
				setStep(step - 1);
				break;

			case NEXT:
				setStep(step + 1);
				break;

			case QUIT:

				if (confirmSave()) {
					if (validateSave()) {
						//save();
						saveByGroupOrder();
						continueWizard = false;
					}
				} else {
					// ûѡˡ˳桱Ҫָԭʼ
					reloadPropsFile();
					continueWizard = false;
				}

				break;

			default:
				processInput(toStep);
			}
		}
	}

	private void print(Object message) {
		String messageString = (message == null) ? "" : message.toString();

		out.print(messageString);
		out.flush();

		if (fileWriter != null) {
			fileWriter.print(messageString);
			fileWriter.flush();
		}
	}

	private void println(Object message) {
		String messageString = (message == null) ? "" : message.toString();

		out.println(((fileWriter == null) ? "" : "") + messageString);

		if (fileWriter != null) {
			fileWriter.println(messageString);
		}
	}

	private void println() {
		println(null);
	}

	private void printTitle() {
		StringBuffer buffer = new StringBuffer();

		buffer.append("qЩ Step ").append(step + 1);
		buffer.append(" of ").append(groups.length).append(" \n");

		buffer.append("            \n");

		if (group.getConfigDescriptor().getDescription() != null) {
			buffer.append(
					formatLines(group.getConfigDescriptor().getDescription(),
							60, LocaleInfo.getDefault().getLocale(),
							"Description  ", "               ")).append(
					"\n");

			buffer.append("\n");
		}

		buffer.append(
				formatLines(group.getConfigDescriptor().getURL().toString(),
						60, LocaleInfo.getDefault().getLocale(),
						"Descriptor   ", "               ")).append("\n");

		buffer.append("\n");

		buffer.append(
				formatLines(propsFile.getAbsolutePath().replace('\\', '/'), 60,
						LocaleInfo.getDefault().getLocale(), "Properties   ",
						"               ")).append("\n");

		buffer.append("            ").append("\n");
		buffer.append("ة").append("\n");

		println();
		println(buffer);
	}

	private void printGroup() {
		if (group.getDescription() != null) {
			println(" " + group.getDescription() + " (*ŵΪ)");
		} else {
			println(" (*ŵΪ)");
		}

		println();

		// ҳƺֵ
		int maxLength = -1;
		int maxLengthValue = -1;

		for (int i = 0; i < props.length; i++) {
			int length = props[i].getName().length();

			if ((length > maxLength) && (length < MAX_ALIGN)) {
				maxLength = length;
			}
		}

		for (int i = 0; i < props.length; i++) {
			String value = getPropertyValue(props[i], true);
			int length = Math.max(props[i].getName().length(), maxLength)
					+ ((value == null) ? 0 : ("  = ".length() + value.length()));

			if ((length > maxLengthValue) && (length < (MAX_ALIGN * 2))) {
				maxLengthValue = length;
			}
		}

		for (int i = 0; i < props.length; i++) {
			ConfigProperty prop = props[i];

			StringBuffer buffer = new StringBuffer();

			// Ǳ, ʾ*
			if (prop.isNullable()) {
				buffer.append("   ");
			} else {
				buffer.append(" * ");
			}

			// ʾproperty
			buffer.append(i + 1).append(" - ");

			// ʾproperty
			buffer.append(prop.getName());

			// ʾpropertyֵ
			String value = getPropertyValue(prop, true);

			if (value != null) {
				for (int j = 0; j < (maxLength - prop.getName().length()); j++) {
					buffer.append(' ');
				}

				buffer.append("  = ").append(value);
			}

			// ʾproperty
			if (prop.getDescription() != null) {
				int length = (value == null) ? prop.getName().length() : (Math
						.max(prop.getName().length(), maxLength)
						+ "  = ".length() + value.length());

				for (int j = 0; j < (maxLengthValue - length); j++) {
					buffer.append(' ');
				}

				buffer.append("   # ").append(prop.getDescription());
			}

			// ֵǱʽͬʱʾʽļֵ
			String evaluatedValue = evaluatePropertyValue(prop, true);

			if ((evaluatedValue != null)
					&& !ObjectUtil.equals(value, evaluatedValue)) {
				buffer.append("\n");

				for (int j = 0; j < maxLength; j++) {
					buffer.append(' ');
				}

				buffer.append("          (").append(evaluatedValue).append(")");

				if (i < (props.length - 1)) {
					buffer.append("\n");
				}
			}

			println(buffer);
		}

		println();
	}

	private int processMenu() {
		while (true) {
			// ʾ
			StringBuffer buffer = new StringBuffer(" ѡ");

			if (props.length > 0) {
				buffer.append("[1-").append(props.length).append("]");
			}

			buffer.append("[Quit]");

			if (step > 0) {
				buffer.append("[Previous]");
			}

			if (step < (groups.length - 1)) {
				buffer.append("[Next]");
			}

			buffer.append(" ");

			print(buffer);

			// ȴ
			String input = null;

			try {
				input = in.readLine();
			} catch (IOException e) {
				throw new ConfigWizardException(e);
			}

			input = (input == null) ? "" : input.trim().toLowerCase();

			if ((input.equals("n") || input.equals("next"))
					&& (step < (groups.length - 1))) {
				return NEXT;
			}

			if ((input.equals("p") || input.equals("previous")) && (step > 0)) {
				return PREVIOUS;
			}

			if (input.equals("q") || input.equals("quit")) {
				return QUIT;
			}

			try {
				int inputValue = Integer.parseInt(input) - 1;

				if ((inputValue >= 0) && (inputValue < props.length)) {
					return inputValue;
				}
			} catch (NumberFormatException e) {
			}
		}
	}

	private void processInput(int index) {
		ConfigProperty prop = props[index];
		StringBuffer buffer = new StringBuffer(" ");

		// ʾproperty
		if (prop.getDescription() != null) {
			buffer.append(prop.getDescription()).append(" ");
		}

		// ʾproperty
		buffer.append(prop.getName()).append(" = ");

		// ʾpropertyֵ
		String value = getPropertyValue(prop, true);

		if (value != null) {
			buffer.append("[").append(value).append("] ");
		}

		print(buffer);

		// ȴ
		String input = null;

		try {
			input = in.readLine();
		} catch (IOException e) {
			throw new ConfigWizardException(e);
		}

		input = (input == null) ? "" : input.trim();

		if ((input == null) || (input.length() == 0)) {
			input = value;
		}

		setProperty(prop.getName(), input);
	}

	private boolean confirmSave() {
		println();
		print(" 浽ļ\"" + propsFile.getAbsoluteFile()
				+ "\", ȷ? [Yes][No] ");

		String input = null;

		try {
			input = in.readLine();
		} catch (IOException e) {
			throw new ConfigWizardException(e);
		}

		input = (input == null) ? "" : input.trim().toLowerCase();

		if (input.equals("n") || input.equals("no")) {
			return false;
		}

		return true;
	}

	private boolean validateSave() {
		if (!validate()) {
			println();
			println(" ֶ" + validatorProperty.getName() + "Ϸ: "
					+ validatorMessage);
			println();
			print(" ȻҪ? [Yes=ǿƱ/No=༭] ");

			String input = null;

			try {
				input = in.readLine();
			} catch (IOException e) {
				throw new ConfigWizardException(e);
			}

			input = (input == null) ? "" : input.trim().toLowerCase();

			if (input.equals("y") || input.equals("yes")) {
				return true;
			}

			printTitle();
			printGroup();
			processInput(validatorIndex);

			return false;
		}

		return true;
	}

	private LinkedHashMap<String, KeyGroup> orderKeyByGroup() {
		LinkedHashMap<String, KeyGroup> groupMaps = new LinkedHashMap<String, KeyGroup>();
		for (int i = 0; i < groups.length; i++) {
			ConfigGroup group = groups[i];

			ConfigProperty[] properties = group.getProperties();

			KeyGroup keyGroup = new KeyGroup();
			keyGroup.setGroupName(group.getName());

			for (int j = 0; j < properties.length; j++) {
				ConfigProperty property = properties[j];
				KeyValuePair pair = new KeyValuePair();
				keyGroup.addKey(property.getName(), property.getDescription());
			}
			groupMaps.put(group.getName(), keyGroup);

		}

		return groupMaps;
	}

	private void saveByGroupOrder() {
		println();
		println("q");
		println(" ļ " + propsFile.getAbsoluteFile() + "...");
		println("");

		try {
			fileWriter = new PrintWriter(new OutputStreamWriter(
					new FileOutputStream(propsFile), propsCharset), true);
		} catch (IOException e) {
			throw new ConfigWizardException(e);
		}
		int keyMaxLength = 0;
		for (Object key : keys) {
			String keyStr = (String) key;
			if (keyStr.length() > keyMaxLength) {
				keyMaxLength = keyStr.length();
			}
		}

		try {
			LinkedHashMap groupMaps = this.orderKeyByGroup();
			for (Object groupKey : groupMaps.keySet()) {
				println("##### Group : " + groupKey);
				KeyGroup group = (KeyGroup) groupMaps.get(groupKey);
				List<KeyValuePair> pairs = group.getPairs();
				for (KeyValuePair pair : pairs) {
					String key = pair.getKey();
					Object value = values.get(key);
					if (value instanceof Expression) {
						value = ((Expression) value).getExpressionText();
					} else if (value == null) {
						value = "";
					} else {
						value = value.toString();
					}

					value = ((String) value).replaceAll("\\\\+", "\\\\\\\\");
					StringBuffer buffer = new StringBuffer();

					buffer.append(key);

					for (int k = 0; k < (keyMaxLength - key.length()); k++) {
						buffer.append(' ');
					}

					buffer.append(" = ").append(value);

					println(buffer);
					println("# " + pair.getDescription());

				}
			}
		} finally {
			fileWriter.close();
			fileWriter = null;
		}
		println("");
		println(" ѱļ: " + propsFile.getAbsoluteFile());
	}

	private void save() {
		println();
		println("q");
		println(" ļ " + propsFile.getAbsoluteFile() + "...");
		println("");

		try {
			fileWriter = new PrintWriter(new OutputStreamWriter(
					new FileOutputStream(propsFile), propsCharset), true);
		} catch (IOException e) {
			throw new ConfigWizardException(e);
		}

		try {
			List[] keyGroups = getSortedKeys(2);

			for (int i = 0; i < keyGroups.length; i++) {
				List keys = keyGroups[i];

				// ҳ
				int maxLength = -1;

				for (Iterator j = keys.iterator(); j.hasNext();) {
					String key = (String) j.next();
					int length = key.length();

					if ((length > maxLength) && (length < MAX_ALIGN)) {
						maxLength = length;
					}
				}

				// property
				for (Iterator j = keys.iterator(); j.hasNext();) {
					String key = (String) j.next();
					Object value = values.get(key);

					if (value instanceof Expression) {
						value = ((Expression) value).getExpressionText();
					} else if (value == null) {
						value = "";
					} else {
						value = value.toString();
					}

					value = ((String) value).replaceAll("\\\\+", "\\\\\\\\");

					StringBuffer buffer = new StringBuffer();

					buffer.append(key);

					for (int k = 0; k < (maxLength - key.length()); k++) {
						buffer.append(' ');
					}

					buffer.append("  = ").append(value);

					println(buffer);
				}

				if (i < (keyGroups.length - 1)) {
					println();
				}
			}
		} finally {
			fileWriter.close();
			fileWriter = null;
		}

		println("");
		println(" ѱļ: " + propsFile.getAbsoluteFile());
	}

	/**
	 * propertieskey򲢷顣
	 * 
	 * @param level
	 *            ļ
	 * 
	 * @return б
	 */
	private List[] getSortedKeys(int level) {
		List keys = new ArrayList(this.keys);

		Collections.sort(keys);

		List groups = new ArrayList();
		List group = null;
		String prefix = null;

		for (Iterator i = keys.iterator(); i.hasNext();) {
			String key = (String) i.next();
			String[] parts = StringUtil.split(key, ".");
			StringBuffer buffer = new StringBuffer();

			for (int j = 0; (j < (parts.length - 1)) && (j < level); j++) {
				if (buffer.length() > 0) {
					buffer.append('.');
				}

				buffer.append(parts[j]);
			}

			String keyPrefix = buffer.toString();

			if (!keyPrefix.equals(prefix)) {
				if (group != null) {
					groups.add(group);
				}

				prefix = keyPrefix;
				group = new ArrayList();
			}

			group.add(key);
		}

		if ((group != null) && (group.size() > 0)) {
			groups.add(group);
		}

		return (List[]) groups.toArray(new List[groups.size()]);
	}

	private void setProperty(String name, String value) {
		Object expr = value;

		if (value != null) {
			expr = CompositeExpression.parse(value);
		}

		if (expr == null) {
			values.remove(name);
			keys.remove(name);
		} else {
			values.put(name, expr);
			values.put(StringUtil.getValidIdentifier(name), expr);
			keys.add(name);
		}
	}

	/**
	 * ȡpropertyֵʽ
	 * 
	 * @param prop
	 *            
	 * @param defaultValue
	 *            ǷʹĬֵ
	 */
	private String getPropertyValue(ConfigProperty prop, boolean defaultValue) {
		Object value = values.get(prop.getName());

		if (defaultValue && (value == null)) {
			value = prop.getDefaultValue();
		}

		if (value instanceof Expression) {
			value = ((Expression) value).getExpressionText();
		}

		if (value instanceof String) {
			String stringValue = (String) value;

			if (stringValue != null) {
				stringValue = stringValue.trim();
			}

			if ((stringValue == null) || (stringValue.length() == 0)) {
				stringValue = null;
			}

			return stringValue;
		}

		return (value == null) ? null : value.toString();
	}

	/**
	 * propertyֵ
	 * 
	 * @param prop
	 *            
	 * @param defaultValue
	 *            ǷʹĬֵ
	 */
	private String evaluatePropertyValue(ConfigProperty prop,
			boolean defaultValue) {
		final String ref = prop.getName();
		Object value = values.get(ref);

		if (defaultValue && (value == null)) {
			value = prop.getDefaultValue();

			if (value instanceof String) {
				Expression expr = CompositeExpression.parse((String) value);

				if (expr != null) {
					value = expr;
				}
			}
		}

		if (value instanceof Expression) {
			value = ((Expression) value).evaluate(new ExpressionContext() {
				public Object get(String key) {
					// ޵ݹ
					if (ref.equals(key)
							|| StringUtil.getValidIdentifier(ref).equals(
									StringUtil.getValidIdentifier(key))) {
						return null;
					} else {
						return values.get(key);
					}
				}

				public void put(String key, Object value) {
					values.put(key, value);
				}
			});
		}

		if (value instanceof String) {
			String stringValue = (String) value;

			if (stringValue != null) {
				stringValue = stringValue.trim();
			}

			if ((stringValue == null) || (stringValue.length() == 0)) {
				stringValue = null;
			}

			return stringValue;
		}

		return (value == null) ? null : value.toString();
	}

	/**
	 * õǰ
	 * 
	 * @param step
	 *            ǰ
	 */
	private void setStep(int step) {
		if (step >= groups.length) {
			step = groups.length - 1;
		}

		if (step < 0) {
			step = 0;
		}

		this.step = step;

		if (step < groups.length) {
			this.group = groups[step];
			this.props = group.getProperties();
		} else {
			this.group = null;
		}
	}

	/**
	 * ʽַַָȣԶС
	 * 
	 * @param text
	 *            Ҫʽַ
	 * @param maxLength
	 *            еĳ
	 * @param locale
	 *            ҵ
	 * @param prefix1
	 *            ǰ׺
	 * @param prefix2
	 *            ڶмеǰ׺
	 * 
	 * @return ʽַ
	 */
	private String formatLines(String text, int maxLength, Locale locale,
			String prefix1, String prefix) {
		BreakIterator boundary = BreakIterator.getLineInstance(locale);
		StringBuffer result = new StringBuffer(prefix1);

		boundary.setText(text);

		int start = boundary.first();
		int end = boundary.next();
		int lineLength = 0;

		while (end != BreakIterator.DONE) {
			String word = text.substring(start, end);

			lineLength = lineLength + word.length();

			if (lineLength >= maxLength) {
				result.append("\n").append(prefix);
				lineLength = word.length();
			}

			result.append(word);
			start = end;
			end = boundary.next();
		}

		return result.toString();
	}
}
