package com.meidusa.toolkit.plugins.autoconfig.util.configuration;

import org.xml.sax.Locator;

/**
 * ļеλ.
 *
 * 
 *
 */
public class Location implements Locator {
    private final String publicId;
    private final String systemId;
    private final int    lineNumber;
    private final int    columnNumber;

    /** յlocation. */
    public static final Location EMPTY_LOCATION = new Location(null, null, -1, -1);

    /**
     * λϢ.
     *
     * @param locator XMLļеλϢ
     */
    public Location(Locator locator) {
        this(locator.getPublicId(), locator.getSystemId(), locator.getLineNumber(),
            locator.getColumnNumber());
    }

    /**
     * λϢ.
     *
     * @param publicId public ID
     * @param systemId system ID, Ҳļ·URL
     * @param lineNumber к
     * @param columnNumber к
     */
    public Location(String publicId, String systemId, int lineNumber, int columnNumber) {
        if (publicId != null) {
            publicId = publicId.trim();

            if ((publicId != null) && (publicId.length() == 0)) {
                publicId = null;
            }
        }

        if (systemId != null) {
            systemId = systemId.trim();

            if ((systemId != null) && (systemId.length() == 0)) {
                systemId = null;
            }
        }

        if (lineNumber <= 0) {
            lineNumber = -1;
        }

        if (columnNumber <= 0) {
            columnNumber = -1;
        }

        this.publicId         = publicId;
        this.systemId         = systemId;
        this.lineNumber       = lineNumber;
        this.columnNumber     = columnNumber;
    }

    /**
     * ȡpublic ID.
     *
     * @return public ID, , 򷵻<code>null</code>
     */
    public String getPublicId() {
        return publicId;
    }

    /**
     * ȡsystem ID.
     *
     * @return system ID, , 򷵻<code>null</code>
     */
    public String getSystemId() {
        return systemId;
    }

    /**
     * ȡк.
     *
     * @return к, , 򷵻<code>-1</code>
     */
    public int getLineNumber() {
        return lineNumber;
    }

    /**
     * ȡк.
     *
     * @return к, , 򷵻<code>-1</code>
     */
    public int getColumnNumber() {
        return columnNumber;
    }

    /**
     * תַʾ.
     *
     * @return ַʾ
     */
    public String toString() {
        if (systemId == null) {
            return "Unknown location";
        }

        StringBuffer buffer = new StringBuffer(systemId);

        if (lineNumber > 0) {
            buffer.append(':').append(lineNumber);

            if (columnNumber > 0) {
                buffer.append(':').append(columnNumber);
            }
        }

        return buffer.toString();
    }
}
