package com.meidusa.toolkit.plugins.autoconfig.util.configuration;

import com.meidusa.toolkit.common.util.exception.ChainedException;

/**
 * Thrown when a <code>Configurable</code> component cannot be configured properly, or if a value
 * cannot be retrieved properly.
 *
 * @author <a href="mailto:dev@avalon.apache.org">Avalon Development Team</a>
 *
 */
public class ConfigurationException extends ChainedException {
    private static final long serialVersionUID = 3257281452726235443L;

    public ConfigurationException(Throwable throwable) {
        super(throwable);
    }

    /**
     * Construct a new <code>ConfigurationException</code> instance.
     *
     * @param message The detail message for this exception.
     */
    public ConfigurationException(final String message) {
        this(message, null);
    }

    /**
     * Construct a new <code>ConfigurationException</code> instance.
     *
     * @param message The detail message for this exception.
     * @param throwable the root cause of the exception
     */
    public ConfigurationException(final String message, final Throwable throwable) {
        super(message, throwable);
    }
}
