package com.meidusa.toolkit.plugins.autoconfig.entry;

import com.meidusa.toolkit.plugins.autoconfig.ConfigException;
import com.meidusa.toolkit.plugins.autoconfig.ConfigResource;
import com.meidusa.toolkit.plugins.autoconfig.ConfigSettings;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigDescriptor;
import com.meidusa.toolkit.plugins.autoconfig.generator.ConfigGeneratorCallback;
import com.meidusa.toolkit.plugins.autoconfig.util.scanner.ScannerException;
import com.meidusa.toolkit.plugins.autoconfig.util.scanner.ZipScanner;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

/**
 * һJarļ͵Ϣ
 *
 * 
 */
public class ZipConfigEntry extends ConfigEntry {
/**
     * һ㡣
     *
     * @param resource ָԴ
     * @param settings autoconfig
     */
    public ZipConfigEntry(ConfigResource resource, ConfigSettings settings) {
        super(resource, settings);
    }

    /**
     * ɨ㡣
     *
     * @param istream zipļ
     */
    protected void scan(InputStream istream) {
        Handler    handler = new Handler();
        ZipScanner scanner = new ZipScanner(getConfigEntryResource().getURL(), handler);

        scanner.setInputStream(istream);

        try {
            scanner.scan();
        } catch (ScannerException e) {
            throw new ConfigException(e);
        }

        subEntries = handler.getSubEntries();

        getGenerator().init();
    }

    /**
     * ļ
     */
    protected void generate(InputStream istream, OutputStream ostream) {
        boolean needCloseOutputStream = false;
        boolean needCloseInputStream  = false;
        boolean success               = false;
        File    destfile              = null;
        File    tempfile              = null;

        getConfigSettings().debug("Processing files in " + getConfigEntryResource());

        ZipInputStream  zis = null;
        ZipOutputStream zos = null;

        try {
            // ostream
            if (ostream == null) {
                destfile = getConfigEntryResource().getFile();

                if ((destfile == null) || !destfile.exists()) {
                    throw new ConfigException("Could not find " + getConfigEntryResource().getURL());
                }

                tempfile              = new File(destfile.getParentFile(),
                                                 destfile.getName() + ".tmp");
                ostream               = new BufferedOutputStream(new FileOutputStream(tempfile),
                                                                 8192);
                needCloseOutputStream = true;
            }

            // istream
            if (istream == null) {
                istream = getConfigEntryResource().getURL().openStream();

                if (!(istream instanceof BufferedInputStream)) {
                    istream = new BufferedInputStream(istream, 8192);
                }

                needCloseInputStream = true;
            }

            zis = new ZipInputStream(istream);
            zos = new ZipOutputStream(ostream);

            ZipEntry zipEntry;

            File     propsFile        = getConfigSettings().getUserPropertiesFile();
            String   propsFileCharset = getConfigSettings().getUserPropertiesFileCharset();

            getGenerator().startSession(propsFile, propsFileCharset);

            while ((zipEntry = zis.getNextEntry()) != null) {
                processZipEntry(zipEntry, zis, zos);
            }

            getGenerator().getSession().checkNonprocessedTemplates();
            //getGenerator().getSession().generateLog(new ZipCallback(zos));

            success = true;
        } catch (IOException e) {
            throw new ConfigException(e);
        } finally {
            getGenerator().closeSession();

            // zipļر
            if (zos != null) {
                try {
                    zos.finish();
                } catch (IOException e) {
                }
            }

            // ɵǰentryԴ򿪵ģŹر
            if (needCloseInputStream && (istream != null)) {
                try {
                    istream.close();
                } catch (IOException e) {
                }
            }

            // ɵǰentryԴ򿪵ģŹر
            if (needCloseOutputStream && (ostream != null)) {
                try {
                    ostream.flush();
                    ostream.close();
                } catch (IOException e) {
                }

                // ɹʱļĳʽļɾʱļ
                if (success) {
                    destfile.delete();
                    tempfile.renameTo(destfile);
                } else {
                    tempfile.delete();
                }
            }
        }
    }

    private void processZipEntry(ZipEntry zipEntry, ZipInputStream zis, ZipOutputStream zos)
            throws IOException {
        String      name     = zipEntry.getName();
        ConfigEntry subEntry = getSubEntry(name);

        if (subEntry != null) {
            // һǶ׵jar entry
            ZipEntry zipEntryToWrite = new ZipEntry(zipEntry.getName());

            zos.putNextEntry(zipEntryToWrite);

            subEntry.generate(zis, zos);
        } else if (getGenerator().isTemplateFile(name)) {
            // ȰڴΪҪö
            ByteArrayOutputStream baos = new ByteArrayOutputStream();

            io(zis, baos);

            byte[] bytes = baos.toByteArray();

            copyZipEntry(zipEntry, new ByteArrayInputStream(bytes), zos);

            // һģ壬ҪӦļ
            getGenerator().getSession().generate(name, new ZipCallback(bytes, zos));
        } else if (getGenerator().isDestFile(name)) {
            // ļģɵļǣʺ֮
        } else if (getGenerator().isDescriptorLogFile(name)) {
            // ļdescriptor־ļǣʺ֮
        } else {
            // һͨļĿ¼Ƽ
            copyZipEntry(zipEntry, zis, zos);
        }
    }

    private void copyZipEntry(ZipEntry zipEntry, InputStream istream, ZipOutputStream zos)
            throws IOException {
        zos.putNextEntry(new ZipEntry(zipEntry));

        if (!zipEntry.isDirectory()) {
            io(istream, zos);
        }
    }

    private void io(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[8192];
        int    amount;

        while ((amount = in.read(buffer)) >= 0) {
            out.write(buffer, 0, amount);
        }
    }

    private ConfigEntry getSubEntry(String name) {
        ConfigEntry[] entries = getSubEntries();

        for (int i = 0; i < entries.length; i++) {
            ConfigEntry subEntry = entries[i];

            if (subEntry.getName().equals(name.replace('\\', '/'))) {
                return subEntry;
            }
        }

        return null;
    }

    /**
     * תַ
     *
     * @return ַʾ
     */
    public String toString() {
        return "ZipConfigEntry[" + getConfigEntryResource() + "]";
    }

    /**
     * Ŀļcallback
     */
    private final class ZipCallback implements ConfigGeneratorCallback {
        private final byte[]          bytes;
        private final ZipOutputStream zos;

        private ZipCallback(ZipOutputStream zos) {
            this(null, zos);
        }

        private ZipCallback(byte[] bytes, ZipOutputStream zos) {
            this.bytes = bytes;
            this.zos   = zos;
        }

        public void nextEntry(ConfigDescriptor descriptor, String template, String dest) {
            try {
                zos.putNextEntry(new ZipEntry(dest));
            } catch (IOException e) {
                throw new ConfigException(e);
            }

            getGenerator().getSession().setInputStream(new ByteArrayInputStream(bytes));
            getGenerator().getSession().setOutputStream(zos);
        }

        public void logEntry(ConfigDescriptor descriptor, String logfileName) {
            try {
                zos.putNextEntry(new ZipEntry(logfileName));
            } catch (IOException e) {
                throw new ConfigException(e);
            }

            getGenerator().getSession().setOutputStream(zos);
        }

        public void closeEntry() {
            // ҪرΪzip stream
        }
    }
}
