package com.meidusa.toolkit.plugins.autoconfig.descriptor.validator;

import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigValidator;
import com.meidusa.toolkit.plugins.autoconfig.util.StringUtil;


import java.net.InetAddress;
import java.net.UnknownHostException;

import org.apache.log4j.Logger;

public class HostExistValidator extends ConfigValidator {
    private static final Logger log      = Logger.getLogger(HostExistValidator.class);
    private String              hostname;

    public Logger getLogger() {
        return log;
    }

    public boolean validate(String value) {
        if (value == null) {
            return true;
        }

        value                            = value.trim();

        if (StringUtil.isEmpty(value)) {
            return true;
        }

        getLogger().info("Validating host name or IP address: " + value);

        hostname = value;

        InetAddress ip = null;

        try {
            ip = InetAddress.getByName(hostname);
        } catch (UnknownHostException e) {
            return false;
        }

        return true;
    }

    protected String getDefaultMessage() {
        return "ǷIP" + hostname;
    }
}
