package com.meidusa.toolkit.plugins.autoconfig.dependency;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.meidusa.toolkit.plugins.autoconfig.DependencyInfo;

public class DependencyFilter {

	private Pattern groupPattern;
	private Pattern artifactPattern;

	private DependencyFilter() {
	};

	public static DependencyFilter compile(DependencyInfo info) {
		DependencyFilter filter = new DependencyFilter();
		filter.groupPattern = Pattern.compile(info.getGroupId());
		filter.artifactPattern = Pattern.compile(info.getArtifactId());
		return filter;
	}

	public boolean match(String groupId, String artifactId) {
		Matcher groupMatcher = groupPattern.matcher(groupId);
		if (groupMatcher.matches()) {
			Matcher artifactMatcher = artifactPattern.matcher(artifactId);
			if (artifactMatcher.matches()) {
				return true;
			}
			return false;
		}
		return false;
	}
}
