/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.wizard.text;

import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigDescriptor;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigGroup;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigProperty;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigValidator;
import com.meidusa.toolkit.plugins.autoconfig.generator.PropertiesLoader;
import com.meidusa.toolkit.plugins.autoconfig.generator.expr.CompositeExpression;
import com.meidusa.toolkit.plugins.autoconfig.generator.expr.Expression;
import com.meidusa.toolkit.plugins.autoconfig.generator.expr.ExpressionContext;
import com.meidusa.toolkit.plugins.autoconfig.util.ObjectUtil;
import com.meidusa.toolkit.plugins.autoconfig.util.StringUtil;
import com.meidusa.toolkit.plugins.autoconfig.util.i18n.LocaleInfo;
import com.meidusa.toolkit.plugins.autoconfig.wizard.text.ConfigWizardException;
import com.meidusa.toolkit.plugins.autoconfig.wizard.text.KeyGroup;
import com.meidusa.toolkit.plugins.autoconfig.wizard.text.KeyValuePair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ConfigWizard {
    private static final int PREVIOUS = -1;
    private static final int NEXT = -2;
    private static final int QUIT = -3;
    private static final int MAX_ALIGN = 40;
    private ConfigDescriptor[] descriptors;
    private ConfigGroup[] groups;
    private File propsFile;
    private String propsCharset;
    private Set keys;
    private Map values;
    private Map encryptInfo;
    private String confirmMessage;
    private BufferedReader in;
    private PrintWriter out;
    private PrintWriter fileWriter;
    private int step;
    private ConfigGroup group;
    private ConfigProperty[] props;
    private ConfigProperty validatorProperty;
    private String validatorMessage;
    private int validatorIndex;

    public ConfigWizard(ConfigDescriptor[] descriptors, File propsFile, String propsCharset) {
        this.descriptors = descriptors;
        this.encryptInfo = new HashMap();
        this.propsFile = propsFile;
        propsCharset = propsCharset == null ? LocaleInfo.getDefault().getCharset() : propsCharset;
        this.propsCharset = propsCharset;
        try {
            this.in = new BufferedReader(new InputStreamReader(System.in, propsCharset));
            this.out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, propsCharset), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new ConfigWizardException(e);
        }
        this.reloadPropsFile();
        ArrayList<ConfigGroup> groups = new ArrayList<ConfigGroup>();
        for (int i = 0; i < descriptors.length; ++i) {
            ConfigGroup[] descriptorGroups = descriptors[i].getGroups();
            for (int j = 0; j < descriptorGroups.length; ++j) {
                ConfigGroup group = descriptorGroups[j];
                groups.add(group);
                for (int k = 0; k < group.getProperties().length; ++k) {
                    ConfigProperty property = group.getProperties()[k];
                    if (property.getEncrypt() == null || property.getEncrypt() == "") continue;
                    this.encryptInfo.put(property.getName(), property.getEncrypt());
                }
            }
        }
        this.groups = groups.toArray(new ConfigGroup[groups.size()]);
        this.setStep(0);
    }

    private void reloadPropsFile() {
        Map loadedValues = PropertiesLoader.loadPropertiesFile(this.propsFile, this.propsCharset);
        this.keys = new HashSet(loadedValues.keySet());
        this.values = new HashMap();
        PropertiesLoader.mergeProperties(this.values, loadedValues);
        PropertiesLoader.mergeProperties(this.values, System.getProperties());
    }

    public void setConfirmMessage(String confirmMessage) {
        this.confirmMessage = confirmMessage;
    }

    public boolean validate() {
        for (int i = 0; i < this.groups.length; ++i) {
            this.setStep(i);
            for (int j = 0; j < this.props.length; ++j) {
                ConfigProperty prop = this.props[j];
                String value = this.evaluatePropertyValue(prop, false);
                for (ConfigValidator validator : prop.getValidators()) {
                    if (validator.validate(value)) continue;
                    this.validatorIndex = j;
                    this.validatorProperty = prop;
                    this.validatorMessage = validator.getMessage();
                    return false;
                }
            }
        }
        return true;
    }

    private void fillDefaultValues() {
        int savedStep = this.step;
        for (int i = 0; i < this.groups.length; ++i) {
            this.setStep(i);
            for (int j = 0; j < this.props.length; ++j) {
                ConfigProperty prop = this.props[j];
                if (this.values.get(prop.getName()) != null && this.keys.contains(prop.getName())) continue;
                String value = this.getPropertyValue(prop, true);
                this.setProperty(prop.getName(), value == null ? "" : value);
            }
        }
        this.setStep(savedStep);
    }

    public void start() {
        boolean continueWizard = true;
        if (this.group == null) {
            return;
        }
        if (this.confirmMessage != null) {
            this.print(this.confirmMessage + " [Yes][No] ");
            try {
                String input = this.in.readLine();
                String string = input = input == null ? "" : input.trim().toLowerCase();
                if (input.equals("n") || input.equals("no")) {
                    continueWizard = false;
                }
            }
            catch (IOException e) {
                throw new ConfigWizardException(e);
            }
        }
        this.println();
        if (continueWizard) {
            this.fillDefaultValues();
        }
        block7: while (continueWizard) {
            this.printTitle();
            this.printGroup();
            int toStep = this.processMenu();
            switch (toStep) {
                case -1: {
                    this.setStep(this.step - 1);
                    continue block7;
                }
                case -2: {
                    this.setStep(this.step + 1);
                    continue block7;
                }
                case -3: {
                    if (this.confirmSave()) {
                        if (!this.validateSave()) continue block7;
                        this.saveByGroupOrder();
                        continueWizard = false;
                        continue block7;
                    }
                    this.reloadPropsFile();
                    continueWizard = false;
                    continue block7;
                }
            }
            this.processInput(toStep);
        }
    }

    private void print(Object message) {
        String messageString = message == null ? "" : message.toString();
        this.out.print(messageString);
        this.out.flush();
        if (this.fileWriter != null) {
            this.fileWriter.print(messageString);
            this.fileWriter.flush();
        }
    }

    private void println(Object message) {
        String messageString = message == null ? "" : message.toString();
        this.out.println((this.fileWriter == null ? "" : "\u2502") + messageString);
        if (this.fileWriter != null) {
            this.fileWriter.println(messageString);
        }
    }

    private void println() {
        this.println(null);
    }

    private void printTitle() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\u256d\u2500\u2500\u2500\u2500\u2500\u2500\u252c\u2500 Step ").append(this.step + 1);
        buffer.append(" of ").append(this.groups.length).append(" \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2508\u2508\u2508\u2508\n");
        buffer.append("\u2502            \u2502\n");
        if (this.group.getConfigDescriptor().getDescription() != null) {
            buffer.append(this.formatLines(this.group.getConfigDescriptor().getDescription(), 60, LocaleInfo.getDefault().getLocale(), "\u2502Description \u2502 ", "\u2502            \u2502   ")).append("\n");
            buffer.append("\u2502\u2508\u2508\u2508\u2508\u2508\u2508\u2502\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\n");
        }
        buffer.append(this.formatLines(this.group.getConfigDescriptor().getURL().toString(), 60, LocaleInfo.getDefault().getLocale(), "\u2502Descriptor  \u2502 ", "\u2502            \u2502   ")).append("\n");
        buffer.append("\u2502\u2508\u2508\u2508\u2508\u2508\u2508\u2502\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\n");
        buffer.append(this.formatLines(this.propsFile.getAbsolutePath().replace('\\', '/'), 60, LocaleInfo.getDefault().getLocale(), "\u2502Properties  \u2502 ", "\u2502            \u2502   ")).append("\n");
        buffer.append("\u2502            \u2502").append("\n");
        buffer.append("\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2534\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508").append("\n");
        this.println();
        this.println(buffer);
    }

    private void printGroup() {
        int i;
        if (this.group.getDescription() != null) {
            this.println(" " + this.group.getDescription() + " (\u6253*\u53f7\u7684\u4e3a\u5fc5\u586b\u9879)");
        } else {
            this.println(" (\u6253*\u53f7\u7684\u4e3a\u5fc5\u586b\u9879)");
        }
        this.println();
        int maxLength = -1;
        int maxLengthValue = -1;
        for (i = 0; i < this.props.length; ++i) {
            int length = this.props[i].getName().length();
            if (length <= maxLength || length >= 40) continue;
            maxLength = length;
        }
        for (i = 0; i < this.props.length; ++i) {
            String value = this.getPropertyValue(this.props[i], true);
            int length = Math.max(this.props[i].getName().length(), maxLength) + (value == null ? 0 : "  = ".length() + value.length());
            if (length <= maxLengthValue || length >= 80) continue;
            maxLengthValue = length;
        }
        for (i = 0; i < this.props.length; ++i) {
            String evaluatedValue;
            int j;
            ConfigProperty prop = this.props[i];
            StringBuffer buffer = new StringBuffer();
            if (prop.isNullable()) {
                buffer.append("   ");
            } else {
                buffer.append(" * ");
            }
            buffer.append(i + 1).append(" - ");
            buffer.append(prop.getName());
            String value = this.getPropertyValue(prop, true);
            if (value != null) {
                for (int j2 = 0; j2 < maxLength - prop.getName().length(); ++j2) {
                    buffer.append(' ');
                }
                buffer.append("  = ").append(value);
            }
            if (prop.getDescription() != null) {
                int length = value == null ? prop.getName().length() : Math.max(prop.getName().length(), maxLength) + "  = ".length() + value.length();
                for (j = 0; j < maxLengthValue - length; ++j) {
                    buffer.append(' ');
                }
                buffer.append("   # ").append(prop.getDescription());
            }
            if ((evaluatedValue = this.evaluatePropertyValue(prop, true)) != null && !ObjectUtil.equals(value, evaluatedValue)) {
                buffer.append("\n");
                for (j = 0; j < maxLength; ++j) {
                    buffer.append(' ');
                }
                buffer.append("          (").append(evaluatedValue).append(")");
                if (i < this.props.length - 1) {
                    buffer.append("\n");
                }
            }
            this.println(buffer);
        }
        this.println();
    }

    private int processMenu() {
        while (true) {
            StringBuffer buffer = new StringBuffer(" \u8bf7\u9009\u62e9");
            if (this.props.length > 0) {
                buffer.append("[1-").append(this.props.length).append("]");
            }
            buffer.append("[Quit]");
            if (this.step > 0) {
                buffer.append("[Previous]");
            }
            if (this.step < this.groups.length - 1) {
                buffer.append("[Next]");
            }
            buffer.append(" ");
            this.print(buffer);
            String input = null;
            try {
                input = this.in.readLine();
            }
            catch (IOException e) {
                throw new ConfigWizardException(e);
            }
            String string = input = input == null ? "" : input.trim().toLowerCase();
            if ((input.equals("n") || input.equals("next")) && this.step < this.groups.length - 1) {
                return -2;
            }
            if ((input.equals("p") || input.equals("previous")) && this.step > 0) {
                return -1;
            }
            if (input.equals("q") || input.equals("quit")) {
                return -3;
            }
            try {
                int inputValue = Integer.parseInt(input) - 1;
                if (inputValue < 0 || inputValue >= this.props.length) continue;
                return inputValue;
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            break;
        }
    }

    private void processInput(int index) {
        ConfigProperty prop = this.props[index];
        StringBuffer buffer = new StringBuffer(" \u8bf7\u8f93\u5165");
        if (prop.getDescription() != null) {
            buffer.append(prop.getDescription()).append(" ");
        }
        buffer.append(prop.getName()).append(" = ");
        String value = this.getPropertyValue(prop, true);
        if (value != null) {
            buffer.append("[").append(value).append("] ");
        }
        this.print(buffer);
        String input = null;
        try {
            input = this.in.readLine();
        }
        catch (IOException e) {
            throw new ConfigWizardException(e);
        }
        String string = input = input == null ? "" : input.trim();
        if (input == null || input.length() == 0) {
            input = value;
        }
        this.setProperty(prop.getName(), input);
    }

    private boolean confirmSave() {
        this.println();
        this.print(" \u5373\u5c06\u4fdd\u5b58\u5230\u6587\u4ef6\"" + this.propsFile.getAbsoluteFile() + "\"\u4e2d, \u786e\u5b9a? [Yes][No] ");
        String input = null;
        try {
            input = this.in.readLine();
        }
        catch (IOException e) {
            throw new ConfigWizardException(e);
        }
        String string = input = input == null ? "" : input.trim().toLowerCase();
        return !input.equals("n") && !input.equals("no");
    }

    private boolean validateSave() {
        if (!this.validate()) {
            this.println();
            this.println(" \u5b57\u6bb5" + this.validatorProperty.getName() + "\u4e0d\u5408\u6cd5: " + this.validatorMessage);
            this.println();
            this.print(" \u60a8\u4ecd\u7136\u8981\u4fdd\u5b58\u5417? [Yes=\u5f3a\u5236\u4fdd\u5b58/No=\u7ee7\u7eed\u7f16\u8f91] ");
            String input = null;
            try {
                input = this.in.readLine();
            }
            catch (IOException e) {
                throw new ConfigWizardException(e);
            }
            String string = input = input == null ? "" : input.trim().toLowerCase();
            if (input.equals("y") || input.equals("yes")) {
                return true;
            }
            this.printTitle();
            this.printGroup();
            this.processInput(this.validatorIndex);
            return false;
        }
        return true;
    }

    private LinkedHashMap<String, KeyGroup> orderKeyByGroup() {
        LinkedHashMap<String, KeyGroup> groupMaps = new LinkedHashMap<String, KeyGroup>();
        for (int i = 0; i < this.groups.length; ++i) {
            ConfigGroup group = this.groups[i];
            ConfigProperty[] properties = group.getProperties();
            KeyGroup keyGroup = new KeyGroup();
            keyGroup.setGroupName(group.getName());
            for (int j = 0; j < properties.length; ++j) {
                ConfigProperty property = properties[j];
                KeyValuePair pair = new KeyValuePair();
                keyGroup.addKey(property.getName(), property.getDescription());
            }
            groupMaps.put(group.getName(), keyGroup);
        }
        return groupMaps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveByGroupOrder() {
        this.println();
        this.println("\u256d\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2508\u2508\u2508\u2508");
        this.println("\u2502 \u4fdd\u5b58\u6587\u4ef6 " + this.propsFile.getAbsoluteFile() + "...");
        this.println("\u2502\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508");
        try {
            this.fileWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(this.propsFile), this.propsCharset), true);
        }
        catch (IOException e) {
            throw new ConfigWizardException(e);
        }
        int keyMaxLength = 0;
        for (Object key : this.keys) {
            String keyStr = (String)key;
            if (keyStr.length() <= keyMaxLength) continue;
            keyMaxLength = keyStr.length();
        }
        try {
            LinkedHashMap<String, KeyGroup> groupMaps = this.orderKeyByGroup();
            for (String groupKey : groupMaps.keySet()) {
                this.println("##### Group : " + groupKey);
                KeyGroup group = groupMaps.get(groupKey);
                LinkedList<KeyValuePair> pairs = group.getPairs();
                for (KeyValuePair pair : pairs) {
                    String key = pair.getKey();
                    Object value = this.values.get(key);
                    value = value instanceof Expression ? ((Expression)value).getExpressionText() : (value == null ? "" : value.toString());
                    value = ((String)value).replaceAll("\\\\+", "\\\\\\\\");
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(key);
                    for (int k = 0; k < keyMaxLength - key.length(); ++k) {
                        buffer.append(' ');
                    }
                    buffer.append(" = ").append(value);
                    this.println(buffer);
                    this.println("# " + pair.getDescription());
                }
            }
        }
        finally {
            this.fileWriter.close();
            this.fileWriter = null;
        }
        this.println("\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508");
        this.println(" \u5df2\u4fdd\u5b58\u81f3\u6587\u4ef6: " + this.propsFile.getAbsoluteFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        this.println();
        this.println("\u256d\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2508\u2508\u2508\u2508");
        this.println("\u2502 \u4fdd\u5b58\u6587\u4ef6 " + this.propsFile.getAbsoluteFile() + "...");
        this.println("\u2502\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508");
        try {
            this.fileWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(this.propsFile), this.propsCharset), true);
        }
        catch (IOException e) {
            throw new ConfigWizardException(e);
        }
        try {
            List[] keyGroups = this.getSortedKeys(2);
            for (int i = 0; i < keyGroups.length; ++i) {
                List keys = keyGroups[i];
                int maxLength = -1;
                for (String key : keys) {
                    int length = key.length();
                    if (length <= maxLength || length >= 40) continue;
                    maxLength = length;
                }
                for (String key : keys) {
                    Object value = this.values.get(key);
                    value = value instanceof Expression ? ((Expression)value).getExpressionText() : (value == null ? "" : value.toString());
                    value = ((String)value).replaceAll("\\\\+", "\\\\\\\\");
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(key);
                    for (int k = 0; k < maxLength - key.length(); ++k) {
                        buffer.append(' ');
                    }
                    buffer.append("  = ").append(value);
                    this.println(buffer);
                }
                if (i >= keyGroups.length - 1) continue;
                this.println();
            }
        }
        finally {
            this.fileWriter.close();
            this.fileWriter = null;
        }
        this.println("\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508");
        this.println(" \u5df2\u4fdd\u5b58\u81f3\u6587\u4ef6: " + this.propsFile.getAbsoluteFile());
    }

    private List[] getSortedKeys(int level) {
        ArrayList keys = new ArrayList(this.keys);
        Collections.sort(keys);
        ArrayList groups = new ArrayList();
        ArrayList<String> group = null;
        String prefix = null;
        for (String key : keys) {
            String[] parts = StringUtil.split(key, ".");
            StringBuffer buffer = new StringBuffer();
            for (int j = 0; j < parts.length - 1 && j < level; ++j) {
                if (buffer.length() > 0) {
                    buffer.append('.');
                }
                buffer.append(parts[j]);
            }
            String keyPrefix = buffer.toString();
            if (!keyPrefix.equals(prefix)) {
                if (group != null) {
                    groups.add(group);
                }
                prefix = keyPrefix;
                group = new ArrayList<String>();
            }
            group.add(key);
        }
        if (group != null && group.size() > 0) {
            groups.add(group);
        }
        return groups.toArray(new List[groups.size()]);
    }

    private void setProperty(String name, String value) {
        Object expr = value;
        if (value != null) {
            expr = CompositeExpression.parse(value);
        }
        if (expr == null) {
            this.values.remove(name);
            this.keys.remove(name);
        } else {
            this.values.put(name, expr);
            this.values.put(StringUtil.getValidIdentifier(name), expr);
            this.keys.add(name);
        }
    }

    private String getPropertyValue(ConfigProperty prop, boolean defaultValue) {
        Object value = this.values.get(prop.getName());
        if (defaultValue && value == null) {
            value = prop.getDefaultValue();
        }
        if (value instanceof Expression) {
            value = ((Expression)value).getExpressionText();
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue != null) {
                stringValue = stringValue.trim();
            }
            if (stringValue == null || stringValue.length() == 0) {
                stringValue = null;
            }
            return stringValue;
        }
        return value == null ? null : value.toString();
    }

    private String evaluatePropertyValue(ConfigProperty prop, boolean defaultValue) {
        Expression expr;
        final String ref = prop.getName();
        Object value = this.values.get(ref);
        if (defaultValue && value == null && (value = prop.getDefaultValue()) instanceof String && (expr = CompositeExpression.parse((String)value)) != null) {
            value = expr;
        }
        if (value instanceof Expression) {
            value = ((Expression)value).evaluate(new ExpressionContext(){

                @Override
                public Object get(String key) {
                    if (ref.equals(key) || StringUtil.getValidIdentifier(ref).equals(StringUtil.getValidIdentifier(key))) {
                        return null;
                    }
                    return ConfigWizard.this.values.get(key);
                }

                @Override
                public void put(String key, Object value) {
                    ConfigWizard.this.values.put(key, value);
                }
            });
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue != null) {
                stringValue = stringValue.trim();
            }
            if (stringValue == null || stringValue.length() == 0) {
                stringValue = null;
            }
            return stringValue;
        }
        return value == null ? null : value.toString();
    }

    private void setStep(int step) {
        if (step >= this.groups.length) {
            step = this.groups.length - 1;
        }
        if (step < 0) {
            step = 0;
        }
        this.step = step;
        if (step < this.groups.length) {
            this.group = this.groups[step];
            this.props = this.group.getProperties();
        } else {
            this.group = null;
        }
    }

    private String formatLines(String text, int maxLength, Locale locale, String prefix1, String prefix) {
        BreakIterator boundary = BreakIterator.getLineInstance(locale);
        StringBuffer result = new StringBuffer(prefix1);
        boundary.setText(text);
        int start = boundary.first();
        int end = boundary.next();
        int lineLength = 0;
        while (end != -1) {
            String word = text.substring(start, end);
            if ((lineLength += word.length()) >= maxLength) {
                result.append("\n").append(prefix);
                lineLength = word.length();
            }
            result.append(word);
            start = end;
            end = boundary.next();
        }
        return result.toString();
    }
}

