/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.util.configuration;

import com.meidusa.toolkit.plugins.autoconfig.util.configuration.Configuration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ConfigurationUtil {
    private ConfigurationUtil() {
    }

    public static Element toElement(Configuration configuration) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            return ConfigurationUtil.createElement(document, configuration);
        }
        catch (ParserConfigurationException pce) {
            throw new IllegalStateException(pce.toString());
        }
    }

    public static boolean equals(Configuration c1, Configuration c2) {
        return c1.getName().equals(c2.getName()) && ConfigurationUtil.areValuesEqual(c1, c2) && ConfigurationUtil.areAttributesEqual(c1, c2) && ConfigurationUtil.areChildrenEqual(c1, c2);
    }

    private static boolean areChildrenEqual(Configuration c1, Configuration c2) {
        ArrayList<Configuration> kids2;
        Configuration[] kids1 = c1.getChildren();
        if (kids1.length != (kids2 = new ArrayList<Configuration>(Arrays.asList(c2.getChildren()))).size()) {
            return false;
        }
        for (int i = 0; i < kids1.length; ++i) {
            if (ConfigurationUtil.findMatchingChild(kids1[i], kids2)) continue;
            return false;
        }
        return kids2.isEmpty();
    }

    private static boolean findMatchingChild(Configuration c, ArrayList matchAgainst) {
        Iterator i = matchAgainst.iterator();
        while (i.hasNext()) {
            if (!ConfigurationUtil.equals(c, (Configuration)i.next())) continue;
            i.remove();
            return true;
        }
        return false;
    }

    private static boolean areAttributesEqual(Configuration c1, Configuration c2) {
        String[] names2;
        String[] names1 = c1.getAttributeNames();
        if (names1.length != (names2 = c2.getAttributeNames()).length) {
            return false;
        }
        for (int i = 0; i < names1.length; ++i) {
            String value2;
            String name = names1[i];
            String value1 = c1.getAttribute(name, null);
            if (value1.equals(value2 = c2.getAttribute(name, null))) continue;
            return false;
        }
        return true;
    }

    private static boolean areValuesEqual(Configuration c1, Configuration c2) {
        String value1 = c1.getValue(null);
        String value2 = c2.getValue(null);
        return value1 == null && value2 == null || value1 != null && value1.equals(value2);
    }

    private static Element createElement(Document document, Configuration configuration) {
        Element element = document.createElement(configuration.getName());
        String content = configuration.getValue(null);
        if (null != content) {
            Text child = document.createTextNode(content);
            element.appendChild(child);
        }
        String[] names = configuration.getAttributeNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String value = configuration.getAttribute(name, null);
            element.setAttribute(name, value);
        }
        Configuration[] children = configuration.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Element child = ConfigurationUtil.createElement(document, children[i]);
            element.appendChild(child);
        }
        return element;
    }
}

