/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.util.collection;

import com.meidusa.toolkit.plugins.autoconfig.util.StringUtil;
import com.meidusa.toolkit.plugins.autoconfig.util.i18n.LocaleInfo;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Properties;

public class ExtendedProperties
extends Properties {
    private static final long serialVersionUID = 3258126960071555380L;
    private static final String KEY_VALUE_SEPARATORS = "= \t\r\n\f";
    private static final String STRICT_KEY_VALUE_SEPARATORS = "=";
    private static final String WHITE_SPACE_CHARS = " \t\r\n\f";

    public synchronized void load(URL resource) throws IOException {
        this.load(resource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(URL resource, String charset) throws IOException {
        charset = this.getCharset(charset);
        InputStream istream = null;
        try {
            istream = resource.openStream();
            if (!(istream instanceof BufferedInputStream)) {
                istream = new BufferedInputStream(istream, 8192);
            }
            this.load(new InputStreamReader(istream, charset), resource.toExternalForm());
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public synchronized void load(InputStream istream) throws IOException {
        String charset = this.getCharset(null);
        if (!(istream instanceof BufferedInputStream)) {
            istream = new BufferedInputStream(istream, 8192);
        }
        this.load(new InputStreamReader(istream, charset), null);
    }

    private String getCharset(String charset) {
        if (charset == null) {
            charset = LocaleInfo.getDefault().getCharset();
        }
        return charset;
    }

    private synchronized void load(Reader reader, String url) throws IOException {
        BufferedReader in = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        int lineNumber = 0;
        while (true) {
            int valueIndex;
            int separatorIndex;
            int keyStart;
            char firstChar;
            String line = in.readLine();
            ++lineNumber;
            if (line == null) {
                return;
            }
            if ((line = line.trim()).length() <= 0 || (firstChar = line.charAt(0)) == '#' || firstChar == '!') continue;
            while (this.isContinueLine(line)) {
                String nextLine = in.readLine();
                if (nextLine == null) {
                    nextLine = "";
                }
                String loppedLine = line.substring(0, line.length() - 1);
                int startIndex = 0;
                for (startIndex = 0; startIndex < nextLine.length() && WHITE_SPACE_CHARS.indexOf(nextLine.charAt(startIndex)) != -1; ++startIndex) {
                }
                nextLine = nextLine.substring(startIndex, nextLine.length());
                line = new String(loppedLine + nextLine);
            }
            int len = line.length();
            for (keyStart = 0; keyStart < len && WHITE_SPACE_CHARS.indexOf(line.charAt(keyStart)) != -1; ++keyStart) {
            }
            if (keyStart == len) continue;
            for (separatorIndex = keyStart; separatorIndex < len; ++separatorIndex) {
                char currentChar = line.charAt(separatorIndex);
                if (currentChar == '\\') {
                    ++separatorIndex;
                    continue;
                }
                if (KEY_VALUE_SEPARATORS.indexOf(currentChar) != -1) break;
            }
            for (valueIndex = separatorIndex; valueIndex < len && WHITE_SPACE_CHARS.indexOf(line.charAt(valueIndex)) != -1; ++valueIndex) {
            }
            if (valueIndex < len && STRICT_KEY_VALUE_SEPARATORS.indexOf(line.charAt(valueIndex)) != -1) {
                ++valueIndex;
            }
            while (valueIndex < len && WHITE_SPACE_CHARS.indexOf(line.charAt(valueIndex)) != -1) {
                ++valueIndex;
            }
            String key = line.substring(keyStart, separatorIndex);
            String value = separatorIndex < len ? line.substring(valueIndex, len) : "";
            key = this.loadConvert(key, url, lineNumber);
            value = this.loadConvert(value, url, lineNumber);
            this.put(key, value);
        }
    }

    private boolean isContinueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    private String loadConvert(String str, String url, int lineNumber) {
        int len = str.length();
        StringBuffer buffer = new StringBuffer(len);
        if (StringUtil.isEmpty(url)) {
            url = "<unknown source>";
        }
        int x = 0;
        while (x < len) {
            char ch;
            if ((ch = str.charAt(x++)) == '\\') {
                if ((ch = str.charAt(x++)) == 'u') {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        ch = str.charAt(x++);
                        switch (ch) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + ch - 48;
                                continue block6;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + ch - 97;
                                continue block6;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + ch - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding at " + url + ", line " + lineNumber);
                            }
                        }
                    }
                    buffer.append((char)value);
                    continue;
                }
                if (ch == '\\') {
                    ch = '\\';
                } else if (ch == 't') {
                    ch = '\t';
                } else if (ch == 'r') {
                    ch = '\r';
                } else if (ch == 'n') {
                    ch = '\n';
                } else if (ch == 'f') {
                    ch = '\f';
                } else {
                    throw new IllegalArgumentException("Invalid \\" + ch + " at " + url + ", line " + lineNumber);
                }
                buffer.append(ch);
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }
}

