/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class FileObject {
    private static final String CURRENT_DIR = ".";
    private static final char COLON_CHAR = ':';
    private static final String UNC_PREFIX = "\\\\";
    private static final String FILE_SEP = File.separator;
    private static final String SLASH = "/";
    private static final String BACKSLASH = "\\";
    private static final char SLASH_CHAR = '/';
    private static final char BACKSLASH_CHAR = '\\';
    private static final String UP_LEVEL_DIR = "../";
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0;
    private String abspath;
    private String relpath;

    public FileObject() {
    }

    public FileObject(File file) {
        this(file == null ? null : file.getAbsolutePath());
    }

    public FileObject(String path) {
        this.setPath(path);
    }

    private FileObject(String abspath, String relpath) {
        this(abspath);
        this.relpath = this.normalizePath(relpath);
    }

    public void setPath(String path) {
        path = this.normalizePath(path);
        boolean endsWithSlash = this.endsWithSlash(path);
        try {
            this.abspath = new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            this.abspath = new File(path).getAbsolutePath();
        }
        if (endsWithSlash && !this.endsWithSlash(this.abspath)) {
            this.abspath = this.abspath + FILE_SEP;
        }
    }

    public String getAbsolutePath() {
        return this.toString(false, SLASH);
    }

    public String getAbsolutePath(String sep) {
        return this.toString(false, sep);
    }

    public String getRelativePath() {
        return this.toString(true, SLASH);
    }

    public String getRelativePath(String sep) {
        return this.toString(true, sep);
    }

    public File getFile() {
        return new File(this.abspath);
    }

    public FileObject newFileObject(FileObject basedir, String path) {
        return this.newFileObject(basedir.newFileObject(path).getFile());
    }

    public FileObject newFileObject(File file) {
        return this.newFileObject(file == null ? null : file.getAbsolutePath());
    }

    public FileObject newFileObject(String path) {
        int i;
        path = this.normalizePath(path);
        boolean endsWithSlash = this.endsWithSlash(path);
        File pathFile = new File(path);
        if (!pathFile.isAbsolute()) {
            pathFile = new File(this.abspath, path);
        }
        try {
            path = pathFile.getCanonicalPath();
        }
        catch (IOException e) {
            path = pathFile.getAbsolutePath();
        }
        if (endsWithSlash && !this.endsWithSlash(path)) {
            path = path + FILE_SEP;
        }
        String thisPrefix = this.getSystemDependentPrefix(this.abspath);
        String prefix = this.getSystemDependentPrefix(path);
        if (!prefix.equals(thisPrefix)) {
            return new FileObject(path);
        }
        String[] thisParts = this.getPathParts(this.abspath, thisPrefix, this.isFile(this.abspath));
        String[] parts = this.getPathParts(path, prefix, false);
        StringBuffer buffer = new StringBuffer();
        if (IS_WINDOWS) {
            for (i = 0; i < thisParts.length && i < parts.length && thisParts[i].equalsIgnoreCase(parts[i]); ++i) {
            }
        } else {
            while (i < thisParts.length && i < parts.length && thisParts[i].equals(parts[i])) {
                ++i;
            }
        }
        if (i < thisParts.length && i < parts.length) {
            for (int j = i; j < thisParts.length; ++j) {
                buffer.append(UP_LEVEL_DIR);
            }
        }
        while (i < parts.length) {
            buffer.append(parts[i]);
            if (i < parts.length - 1) {
                buffer.append('/');
            }
            ++i;
        }
        String relpath = buffer.toString();
        if (endsWithSlash && !this.endsWithSlash(relpath)) {
            relpath = relpath + SLASH;
        }
        return new FileObject(path, relpath);
    }

    public Map tree(FileObject basedir, String[] paths) {
        return this.tree(basedir, Arrays.asList(paths));
    }

    public Map tree(FileObject basedir, Collection paths) {
        HashMap<String, String> tree = new HashMap<String, String>();
        Iterator i = paths.iterator();
        while (i.hasNext()) {
            String abspath = i.next().toString();
            String pathToBasedir = basedir.newFileObject(abspath).getRelativePath();
            String path = this.newFileObject(abspath).getRelativePath();
            StringTokenizer tokenizer = new StringTokenizer(pathToBasedir, SLASH);
            HashMap node = tree;
            while (tokenizer.hasMoreTokens()) {
                String s = tokenizer.nextToken();
                if (tokenizer.hasMoreTokens()) {
                    HashMap tmp = (HashMap)node.get(s);
                    if (tmp == null) {
                        tmp = new HashMap();
                        node.put(s, tmp);
                    }
                    node = tmp;
                    continue;
                }
                node.put(s, path);
            }
        }
        return tree;
    }

    public String toString() {
        return this.toString(false, SLASH);
    }

    private String toString(boolean relative, String sep) {
        String path = relative ? (this.relpath == null ? this.abspath : this.relpath) : this.abspath;
        if (this.isUncPath(path)) {
            return path;
        }
        if (BACKSLASH.equals(sep)) {
            return path.replace('/', '\\');
        }
        return path.replace('\\', '/');
    }

    private boolean isFile(String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        return file.isFile() && file.exists();
    }

    private String normalizePath(String path) {
        if (path == null) {
            return CURRENT_DIR;
        }
        if ((path = path.trim()).length() == 0) {
            return CURRENT_DIR;
        }
        return path;
    }

    private boolean isUncPath(String path) {
        return path.startsWith(UNC_PREFIX);
    }

    private boolean endsWithSlash(String path) {
        return path.endsWith(SLASH) || path.endsWith(BACKSLASH);
    }

    private String getSystemDependentPrefix(String path) {
        if (IS_WINDOWS) {
            if (this.isUncPath(path)) {
                int index = path.indexOf(FILE_SEP, UNC_PREFIX.length());
                if (index != -1) {
                    return path.substring(0, index);
                }
                return path;
            }
            if (path.length() > 1 && path.charAt(1) == ':') {
                return path.substring(0, 2).toLowerCase();
            }
        }
        return "";
    }

    private String[] getPathParts(String path, String prefix, boolean treatAsFile) {
        StringTokenizer tokenizer = new StringTokenizer(path.substring(prefix.length()), FILE_SEP);
        ArrayList<String> parts = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            parts.add(tokenizer.nextToken());
        }
        if (treatAsFile) {
            parts.remove(parts.size() - 1);
        }
        return parts.toArray(new String[parts.size()]);
    }
}

