/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.generator;

import com.meidusa.toolkit.plugins.autoconfig.ConfigConstant;
import com.meidusa.toolkit.plugins.autoconfig.ConfigException;
import java.io.CharArrayWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class VelocityTemplateEngine {
    private static Logger log = Logger.getLogger(VelocityTemplateEngine.class);
    private static VelocityTemplateEngine instance;
    private VelocityEngine engine = new VelocityEngine();

    public static VelocityTemplateEngine getInstance() {
        if (instance == null) {
            instance = new VelocityTemplateEngine();
        }
        return instance;
    }

    public VelocityTemplateEngine() {
        this.engine.setProperty("parser.pool.size", (Object)new Integer(1));
        this.engine.setProperty("runtime.log.logsystem", (Object)new LogSystem());
        this.engine.setProperty("velocimacro.context.localscope", (Object)"true");
        this.engine.setProperty("resource.loader", (Object)"classpath");
        this.engine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        this.engine.setProperty("velocimacro.library", (Object)ConfigConstant.VELOCITY_MACRO_FILE);
        try {
            this.engine.init();
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] render(Context context, Reader reader) throws Exception {
        CharArrayWriter writer = new CharArrayWriter();
        try {
            this.render(context, reader, writer);
        }
        finally {
            writer.flush();
            writer.close();
        }
        return writer.toCharArray();
    }

    public void render(Context context, Reader reader, Writer writer) throws Exception {
        this.engine.evaluate(context, writer, "config", reader);
    }

    private class LogSystem
    implements org.apache.velocity.runtime.log.LogSystem {
        private LogSystem() {
        }

        public void init(RuntimeServices runtimeServices) {
        }

        public void logVelocityMessage(int level, String message) {
            switch (level) {
                case 0: {
                    log.debug((Object)this.processMessage(message));
                    break;
                }
                case 1: {
                    log.info((Object)this.processMessage(message));
                    break;
                }
                case 2: {
                    log.warn((Object)this.processMessage(message));
                    break;
                }
                case 3: {
                    log.error((Object)this.processMessage(message));
                }
            }
        }

        private String processMessage(String message) {
            if (message != null) {
                message = message.replaceFirst("^[\\w\\.\\$]+Exception: ", "");
            }
            return message;
        }
    }
}

