/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.descriptor.validator;

import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigValidator;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigValidatorException;
import com.meidusa.toolkit.plugins.autoconfig.util.StringUtil;
import org.apache.log4j.Logger;

public class ChoiceValidator
extends ConfigValidator {
    private static final Logger log = Logger.getLogger(ChoiceValidator.class);
    private String[] choices;

    @Override
    public Logger getLogger() {
        return log;
    }

    public String[] getAllChoices() {
        return this.choices;
    }

    public void setChoice(String choice) {
        this.choices = StringUtil.split(choice);
    }

    @Override
    public boolean validate(String value) {
        String[] choices = this.getAllChoices();
        if (choices == null || choices.length == 0) {
            throw new ConfigValidatorException("You must define an attribute called 'choice' for choice validator");
        }
        if (value == null) {
            return true;
        }
        if (StringUtil.isEmpty(value = value.trim())) {
            return true;
        }
        if (this.getLogger().isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Validating value with choice[");
            for (int i = 0; i < choices.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(choices[i]);
            }
            buffer.append("]: ").append(value);
            this.getLogger().debug((Object)buffer.toString());
        }
        for (int i = 0; i < choices.length; ++i) {
            if (!value.equals(choices[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getDefaultMessage() {
        StringBuffer buffer = new StringBuffer("\u60a8\u5fc5\u987b\u5728\u4e0b\u5217\u503c\u4e2d\u9009\u62e9\uff1a");
        String[] choices = this.getAllChoices();
        for (int i = 0; i < choices.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(choices[i]);
        }
        return buffer.toString();
    }
}

